/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import com.jeecms.exception.GlobalException;
import com.jeecms.exception.error.CoreErrs;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidUtil {
    private static final Pattern phonePattern = Pattern.compile("^1[3456789]\\d{9}$");
    private static final Pattern emailPattern = Pattern.compile("^\\s*\\w+(?:\\.?[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$");

    public static void validPhone(String phone, boolean emptyable, boolean nullable) throws GlobalException {
        if (!nullable && phone == null) {
            throw new GlobalException(CoreErrs.PHONE_CANNOT_BE_NULL);
        }
        if (!emptyable && StringUtils.isEmpty((CharSequence)phone)) {
            throw new GlobalException(CoreErrs.PHONE_CANNOT_BE_EMPTY);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            if (phone.length() != 11) {
                throw new GlobalException(CoreErrs.PHONE_LENGTH_ONLY_FOR_11_BITS);
            }
            if (!phonePattern.matcher(phone).find()) {
                throw new GlobalException(CoreErrs.PHONE_FORMAT_IS_NOT_CORRECT);
            }
        }
    }

    public static boolean checkPhone(String phone) {
        return phone.length() == 11 && phonePattern.matcher(phone).find();
    }

    public static boolean checkEmail(String email) {
        return emailPattern.matcher(email).find();
    }

    public static void voildEmail(String email, boolean emptyable, boolean nullable) throws GlobalException {
        if (!nullable && email == null) {
            throw new GlobalException(CoreErrs.EMAIL_CANNOT_BE_NULL);
        }
        if (!emptyable && StringUtils.isEmpty((CharSequence)email)) {
            throw new GlobalException(CoreErrs.EMAIL_CANNOT_BE_EMPTY);
        }
        if (StringUtils.isNotBlank((CharSequence)email) && !emailPattern.matcher(email).find()) {
            throw new GlobalException(CoreErrs.EMAIL_FORMAT_IS_NOT_CORRECT);
        }
    }
}

