/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.math.BigDecimal;

public class UnitUtils {
    private static final BigDecimal bd100 = BigDecimal.valueOf(100.0);
    private static final BigDecimal bd1000 = BigDecimal.valueOf(1000.0);

    public static long convertKgToG(BigDecimal num) {
        return num.multiply(bd1000).longValue();
    }

    public static long convertKgToG(String num) {
        return UnitUtils.convertKgToG(Double.parseDouble(num));
    }

    public static long convertKgToG(double num) {
        return UnitUtils.convertKgToG(BigDecimal.valueOf(num));
    }

    public static BigDecimal convertGToKg(long num) {
        BigDecimal bdFen = BigDecimal.valueOf(num);
        return UnitUtils.convertGToKg(bdFen);
    }

    public static BigDecimal intConvertGToKg(long num) {
        BigDecimal bdFen = BigDecimal.valueOf(num);
        return UnitUtils.intConvertGToKg(bdFen);
    }

    public static BigDecimal convertFenToYuan(long fen) {
        return UnitUtils.convertFenToYuan(fen, 2);
    }

    public static BigDecimal convertFenToYuan(long fen, int scale) {
        BigDecimal bdFen = BigDecimal.valueOf(fen);
        return UnitUtils.convertFenToYuan(bdFen, scale);
    }

    public static String convertFenToYuanStr(long fen) {
        BigDecimal bdFen = BigDecimal.valueOf(fen);
        return UnitUtils.convertFenToYuan(bdFen).toString();
    }

    public static BigDecimal convertFenToYuan(double fen) {
        return UnitUtils.convertFenToYuan(fen, 2);
    }

    public static BigDecimal convertFenToYuan(double fen, int scale) {
        BigDecimal bdFen = BigDecimal.valueOf(fen);
        return UnitUtils.convertFenToYuan(bdFen, scale);
    }

    public static BigDecimal convertFenToYuan(float fen) {
        return UnitUtils.convertFenToYuan(fen, 2);
    }

    public static BigDecimal convertFenToYuan(float fen, int scale) {
        BigDecimal bdFen = BigDecimal.valueOf(fen);
        return UnitUtils.convertFenToYuan(bdFen, scale);
    }

    public static BigDecimal convertFenToYuan(int fen) {
        return UnitUtils.convertFenToYuan(fen, 2);
    }

    public static BigDecimal convertFenToYuan(int fen, int scale) {
        BigDecimal bdFen = BigDecimal.valueOf(fen);
        return UnitUtils.convertFenToYuan(bdFen, scale);
    }

    public static BigDecimal convertFenToYuan(BigDecimal bdFen) {
        return UnitUtils.convertFenToYuan(bdFen, 2);
    }

    public static BigDecimal convertFenToYuan(BigDecimal bdFen, int scale) {
        BigDecimal bdYuan = bdFen.divide(bd100, scale, 1);
        return bdYuan;
    }

    public static BigDecimal convertGToKg(BigDecimal bdFen) {
        BigDecimal bdKg = bdFen.divide(bd1000, 3, 7);
        return bdKg;
    }

    public static BigDecimal intConvertGToKg(BigDecimal bdFen) {
        BigDecimal bdKg = bdFen.divide(bd1000, 0, 7);
        return bdKg;
    }

    public static long convertYuanToFen(String yuan) {
        return UnitUtils.convertYuanToFen(Double.parseDouble(yuan));
    }

    public static long convertYuanToFen(double yuan) {
        BigDecimal bdYuan = BigDecimal.valueOf(yuan);
        return UnitUtils.convertYuanToFen(bdYuan);
    }

    public static long convertYuanToFen(float yuan) {
        BigDecimal bdYuan = BigDecimal.valueOf(yuan);
        return UnitUtils.convertYuanToFen(bdYuan);
    }

    public static long convertYuanToFen(BigDecimal bdYuan) {
        BigDecimal bdFen = bdYuan.multiply(bd100);
        return bdFen.longValue();
    }

    public static void main(String[] args) {
        long l = UnitUtils.convertYuanToFen("3.00");
        System.out.println(l);
    }
}

