/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.bean.BeanUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class URLUtil
extends cn.hutool.core.util.URLUtil {
    public static final String PROTOCOL_HTTP = "http://";
    public static final String PROTOCOL_HTTPS = "https://";
    public static final List<String> TOP_DOMAINS = Arrays.asList(".com", ".net", ".cn", ".org", ".info", ".me", ".cc", ".com.cn", ".net.cn", ".name", ".mobi", ".pw", ".tv", ".wang", ".club", ".ac.cn", ".\u5728\u7ebf", ".\u4e2d\u56fd", ".\u4e2d\u6587\u7f51", ".xyz", ".vip", ".\u7f51\u5740", ".beer", ".work", ".fashion", ".luxe", ".yoga", ".top", ".love", ".online", ".\u8d2d\u7269", ".ltd", ".chat", ".group", ".pub", ".run", ".city", ".live", ".pro", ".red", ".\u7f51\u5e97", ".pet", ".kim", ".\u79fb\u52a8", ".blue", ".ski", ".pink", ".space", ".tech", ".host", ".fun", ".site", ".store", ".gold", ".cool", ".email", ".life", ".art", ".icu", ".press", ".company", ".ink", ".design", ".wiki", ".video", ".plus", ".center", ".fund", ".guru", ".show", ".team", ".today", ".world", ".zone", ".social", ".bio", ".black", ".green", ".lotto", ".organic", ".poker", ".promo", ".vote", ".archi", ".voto", ".\u7f51\u7ad9", ".\u5546\u5e97", ".\u4f01\u4e1a", ".\u5a31\u4e50", ".\u6e38\u620f", ".fit", ".website", ".tk", ".asia", ".org.cn", ".space", ".tech", ".host", ".fun", ".site", ".store");

    private URLUtil() {
    }

    public static <P> String splice(String baseUrl, P params) {
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!baseUrl.startsWith(PROTOCOL_HTTP) && !baseUrl.startsWith(PROTOCOL_HTTPS)) {
            sb.append(PROTOCOL_HTTP).append(baseUrl);
        } else {
            sb.append(baseUrl);
        }
        if (params == null) {
            return sb.toString();
        }
        Map paramMap = params instanceof Map ? (Map)params : BeanUtil.beanToMap(params);
        sb.append("?");
        for (Map.Entry entry : paramMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static String getFilename(String uriStr) {
        String path = URLUtil.getPath(uriStr);
        return path.substring(path.lastIndexOf("/"));
    }

    public static String fixUrl(String url) {
        if (url == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)(url = url.trim())) && !StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)PROTOCOL_HTTP) && !StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)PROTOCOL_HTTPS)) {
            return PROTOCOL_HTTP + url;
        }
        return url;
    }

    public static String getPath(String uriStr) {
        return cn.hutool.core.util.URLUtil.getPath((String)URLUtil.encode((String)uriStr));
    }

    public static String getSecondDomain(String domain) {
        String secondDomain = null;
        for (String topDomain : TOP_DOMAINS) {
            if (!domain.endsWith(topDomain)) continue;
            int index = domain.lastIndexOf(46, domain.length() - topDomain.length() - 1);
            secondDomain = domain.substring(index + 1);
            break;
        }
        if (secondDomain == null) {
            int index = domain.lastIndexOf(46, domain.lastIndexOf(46) - 1);
            secondDomain = domain.substring(index + 1);
        }
        return secondDomain;
    }
}

