/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TextTemplate {
    private static final String DEFAULT_TEMPLATE_VAR_REG = "\\{\\{([A-Za-z]+?[A-Za-z0-9_]*?)}}";
    private static final Map<String, TextTemplate> TEXT_TEMPLATE_CACHE = new ConcurrentHashMap<String, TextTemplate>();
    private final Pattern templateVarPattern;
    private String templateStr;
    private LinkedHashMap<Region, String> templateVer;

    private TextTemplate(String templateStr) {
        this(DEFAULT_TEMPLATE_VAR_REG, templateStr);
    }

    private TextTemplate(String rex, String templateStr) {
        this.templateVarPattern = Pattern.compile(rex);
        this.templateStr = Objects.requireNonNull(templateStr);
        this.templateVer = new LinkedHashMap();
        Matcher matcher = this.templateVarPattern.matcher(templateStr);
        while (matcher.find()) {
            this.templateVer.put(new Region(matcher.start(), matcher.end()), matcher.group(1));
        }
    }

    public String mold(Map<String, String> vals) {
        return this.mold(vals, true);
    }

    public String mold(Map<String, String> vals, boolean rigor) {
        vals = vals == null ? Collections.emptyMap() : vals;
        StringBuilder sb = new StringBuilder(this.templateStr);
        int offset = 0;
        for (Map.Entry<Region, String> entry : this.templateVer.entrySet()) {
            Region region = entry.getKey();
            String v = vals.get(entry.getValue());
            if (v == null) continue;
            sb.replace(region.start + offset, region.end + offset, v);
            offset += v.length() - (region.end - region.start);
        }
        if (rigor) {
            HashSet<String> tvarSet = new HashSet<String>(this.templateVer.values());
            tvarSet.removeAll(vals.keySet());
            if (!tvarSet.isEmpty()) {
                throw new IllegalArgumentException("\u6a21\u677f\u586b\u5145\u9519\u8bef: \u7f3a\u5c11\u53d8\u91cf[" + StringUtils.join(tvarSet, (String)",") + "]");
            }
        }
        return sb.toString();
    }

    public static TextTemplate compile(String templateStr) {
        return TextTemplate.compile(DEFAULT_TEMPLATE_VAR_REG, templateStr);
    }

    public static TextTemplate compile(String reg, String templateStr) {
        TextTemplate textTemplate = TEXT_TEMPLATE_CACHE.get(reg + "#" + templateStr);
        if (textTemplate == null) {
            textTemplate = new TextTemplate(reg, templateStr);
            TEXT_TEMPLATE_CACHE.put(reg + "#" + templateStr, textTemplate);
        }
        return textTemplate;
    }

    public static String mold(String templateStr, Map<String, String> vals) {
        return TextTemplate.mold(templateStr, vals, true);
    }

    public static String mold(String reg, String templateStr, Map<String, String> vals) {
        return TextTemplate.mold(reg, templateStr, vals, true);
    }

    public static String mold(String templateStr, Map<String, String> vals, boolean rigor) {
        return TextTemplate.compile(templateStr).mold(vals, rigor);
    }

    public static String mold(String reg, String templateStr, Map<String, String> vals, boolean rigor) {
        return TextTemplate.compile(reg, templateStr).mold(vals, rigor);
    }

    private static class Region {
        int start;
        int end;

        public Region(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Region && ((Region)obj).start == this.start && ((Region)obj).end == this.end;
        }
    }
}

