/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;

public class StrUtil
extends cn.hutool.core.util.StrUtil {
    public static final String DOUBLE_DIAGONAL = "//";
    public static final String VERTICAL_LINE = "|";
    public static final String STOP_CHAR = "\u3001";
    public static final String ELLIPSIS_DOT = "...";
    static final Pattern NUMBER_PATTERN = Pattern.compile("[1-9]*");
    static final Pattern NUM_PATTERN = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");
    static final String URL_PATTERN_STR = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,4})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    static final Pattern URL_PATTERN = Pattern.compile("^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,4})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    static final int URL_MIN_LENGTH = 5;

    private StrUtil() {
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase();
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase();
    }

    public static String[] splitAndTrim(String str, String ... seps) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new String[0];
        }
        if (ArrayUtil.isEmpty((Object[])seps)) {
            return new String[]{str};
        }
        String sep = seps[0];
        for (int i = 1; i < seps.length; ++i) {
            str = StringUtils.replace((String)str, (String)seps[i], (String)sep);
        }
        String[] arr = StringUtils.split((String)str, (String)sep);
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = arr[i].trim();
        }
        return arr;
    }

    public static String txt2htm(String txt) {
        if (StringUtils.isBlank((CharSequence)txt)) {
            return txt;
        }
        StringBuilder sb = new StringBuilder((int)((double)txt.length() * 1.2));
        boolean doub = false;
        block7: for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == ' ') {
                if (doub) {
                    sb.append(' ');
                    doub = false;
                    continue;
                }
                sb.append("&nbsp;");
                doub = true;
                continue;
            }
            doub = false;
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    sb.append("<br/>");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String trimHtml2Txt(String html) {
        html = html.replaceAll("\\<head>[\\s\\S]*?</head>(?i)", "");
        html = html.replaceAll("\\<!--[\\s\\S]*?-->", "");
        html = html.replaceAll("\\<![\\s\\S]*?>", "");
        html = html.replaceAll("\\<style[^>]*>[\\s\\S]*?</style>(?i)", "");
        html = html.replaceAll("\\<script[^>]*>[\\s\\S]*?</script>(?i)", "");
        html = html.replaceAll("\\<w:[^>]+>[\\s\\S]*?</w:[^>]+>(?i)", "");
        html = html.replaceAll("\\<xml>[\\s\\S]*?</xml>(?i)", "");
        html = html.replaceAll("\\<table>[\\s\\S]*?</table>(?i)", "");
        html = html.replaceAll("\\<html[^>]*>|<body[^>]*>|</html>|</body>(?i)", "");
        html = html.replaceAll("\\\r\n|\n|\r", "");
        html = html.replaceAll("\\<br[^>]*>(?i)", "\r\n");
        html = html.replaceAll("\\</p>(?i)", "\r\n");
        html = html.replaceAll("\\<p>(?i)", "\r\n");
        html = html.replace("[NextPage][/NextPage]", "");
        html = html.replaceAll("\\<[^>]+>", "");
        return html.trim();
    }

    public static List<String> getVideoSrc(String htmlCode) {
        ArrayList<String> imageSrcList = new ArrayList<String>();
        String regular = "<video(.*?)src=\"(.*?)\"(.*?)</video>";
        String videoPre = "<video(.*?)src=\"";
        String videoSub = "\"(.*?)</video>";
        Pattern p = Pattern.compile(regular, 2);
        Matcher m = p.matcher(htmlCode);
        String src = null;
        while (m.find()) {
            src = m.group();
            src = src.replaceAll(videoPre, "").replaceAll(videoSub, "").trim();
            imageSrcList.add(src);
        }
        return imageSrcList;
    }

    public static String textCut(String s, int len, String append) {
        int i;
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen <= len) {
            return s;
        }
        int maxCount = len * 2;
        int count = 0;
        for (i = 0; count < maxCount && i < slen; ++i) {
            if (s.codePointAt(i) < 256) {
                ++count;
                continue;
            }
            count += 2;
        }
        if (i < slen) {
            if (count > maxCount) {
                --i;
            }
            if (!StringUtils.isBlank((CharSequence)append)) {
                int len256 = 256;
                i = s.codePointAt(i - 1) < len256 ? (i -= 2) : --i;
                return s.substring(0, i) + append;
            }
            return s.substring(0, i);
        }
        return s;
    }

    public static String htmlCut(String s, int len, String append) {
        String text = StrUtil.html2Text(s, len * 2);
        return StrUtil.textCut(text, len, append);
    }

    public static String html2Text(String html, int len) {
        try {
            Node node;
            Lexer lexer = new Lexer(html);
            StringBuilder sb = new StringBuilder(html.length());
            while ((node = lexer.nextNode()) != null) {
                if (node instanceof TextNode) {
                    sb.append(node.toHtml());
                }
                if (sb.length() <= len) continue;
            }
            return sb.toString();
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isGreaterZeroNumeric(String str) {
        return NUMBER_PATTERN.matcher(str).matches();
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Matcher isNum = NUM_PATTERN.matcher(str);
        return isNum.matches();
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof String && StrUtil.isNumeric((String)obj);
    }

    public static <T> String iterableToString(Iterable<T> list) {
        if (list == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (T string : list) {
            result.append(string.toString()).append(",");
        }
        String str = result.toString();
        if (list.iterator().hasNext()) {
            str = str.substring(0, result.length() - 1);
        }
        return str;
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        if (css == null || css.length == 0) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StrUtil.isEmpty((CharSequence)cs)) continue;
            return true;
        }
        return false;
    }

    public static String escapeUnicode(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return " ";
        }
        StringBuilder sb = new StringBuilder(input.length());
        Formatter format = new Formatter(sb);
        for (char c : input.toCharArray()) {
            if (c < '\u0080') {
                sb.append(c);
                continue;
            }
            format.format("\\u%04x", c);
        }
        return sb.toString();
    }

    public static boolean isPhone(String phone) {
        String regex = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";
        if (phone.length() != 11) {
            return false;
        }
        return phone.matches(regex);
    }

    public static boolean isEmail(String string) {
        if (string == null) {
            return false;
        }
        String regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern p = Pattern.compile(regEx1);
        Matcher m = p.matcher(string);
        return m.matches();
    }

    public static boolean isBankCard(String cardId) {
        char n;
        int cardIdLenMin = 16;
        int cardIdLenMax = 19;
        if (cardId == null || cardId.length() < cardIdLenMin || cardId.length() > cardIdLenMax) {
            return false;
        }
        char bit = StrUtil.getBankCardCheckCode(cardId.substring(0, cardId.length() - 1));
        if (bit == (n = 'N')) {
            return false;
        }
        return cardId.charAt(cardId.length() - 1) == bit;
    }

    private static char getBankCardCheckCode(String nonCheckCodeCardId) {
        if (nonCheckCodeCardId == null || nonCheckCodeCardId.trim().length() == 0 || !nonCheckCodeCardId.matches("\\d+")) {
            return 'N';
        }
        char[] chs = nonCheckCodeCardId.trim().toCharArray();
        int luhnSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhnSum += k;
            --i;
            ++j;
        }
        return luhnSum % 10 == 0 ? (char)'0' : (char)(10 - luhnSum % 10 + 48);
    }

    public static String hideStr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (StrUtil.isPhone(str)) {
            return str.substring(0, 3) + "****" + str.substring(str.length() - 4);
        }
        if (StrUtil.isEmail(str)) {
            int index = str.indexOf("@");
            String emailName = str.substring(0, index + 1);
            return emailName.substring(0, 1) + "****" + str.substring(index);
        }
        if (StrUtil.isBankCard(str)) {
            return str.substring(0, 4) + "****" + str.substring(str.length() - 4);
        }
        return str.substring(0, 1) + "****" + str.substring(str.length() - 1);
    }

    public static JSONObject urlParamToJson(String parmStr) {
        JSONObject object = new JSONObject();
        String simple = "&";
        String eq = "=";
        if (parmStr.contains(simple)) {
            String[] uStrings;
            for (String string : uStrings = parmStr.split(simple)) {
                String[] common = string.split(eq);
                object.put(common[0], (Object)common[1]);
            }
        } else {
            String[] common = parmStr.split(eq);
            object.put(common[0], (Object)common[1]);
        }
        return object;
    }

    public static String getTopDomain(String domain) {
        String regStr = "[0-9a-zA-Z]+((\\.com.cn)|(\\.com.hk)|(\\.net.cn)|(\\.org.cn)|(\\.gov.cn)||(\\.edu.cn)(\\.com)|(\\.cn)|(\\.org)|(\\.gov)|(\\.net)|(\\.edu)|(\\.xyz)|(\\.xin)|(\\.club)|(\\.shop)|(\\.site)|(\\.wang)|(\\.top)|(\\.win)|(\\.online)|(\\.tech)|(\\.store)|(\\.bid)|(\\.cc)|(\\.ren)|(\\.lol)|(\\.pro)|(\\.red)|(\\.kim)|(\\.space)|(\\.link)|(\\.click)|(\\.news)|(\\.news)|(\\.ltd)|(\\.website)|(\\.biz)|(\\.help)|(\\.mom)|(\\.work)|(\\.date)|(\\.loan)|(\\.mobi)|(\\.live)|(\\.studio)|(\\.info)|(\\.pics)|(\\.photo)|(\\.trade)|(\\.vc)|(\\.party)|(\\.game)|(\\.rocks)|(\\.band)|(\\.gift)|(\\.wiki)|(\\.design)|(\\.software)|(\\.social)|(\\.lawyer)|(\\.engineer)|(\\.org)|(\\.name)|(\\.tv)|(\\.me)|(\\.asia)|(\\.co)|(\\.press)|(\\.video)|(\\.market)|(\\.games)|(\\.science)|(\\.\u4e2d\u56fd)|(\\.\u516c\u53f8)|(\\.\u7f51\u7edc)|(\\.pub)|(\\.la)|(\\.auction)|(\\.email)|(\\.sex)|(\\.sexy)|(\\.one)|(\\.host)|(\\.rent)|(\\.fans)|(\\.cn.com)|(\\.life)|(\\.cool)|(\\.run)|(\\.gold)|(\\.rip)|(\\.ceo)|(\\.sale)|(\\.hk)|(\\.io)|(\\.gg)|(\\.tm)|(\\.gs)|(\\.us))";
        Pattern p = Pattern.compile(regStr);
        Matcher m = p.matcher(domain);
        String topdomain = "";
        while (m.find()) {
            topdomain = m.group();
        }
        return topdomain;
    }

    public static String left(CharSequence cs, int len) {
        return cs.toString().substring(0, len);
    }

    public static String right(CharSequence cs, int len) {
        return cs.toString().substring(cs.length() - len);
    }

    public static boolean containsUrl(String text) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return false;
        }
        if (text.length() <= 5) {
            return false;
        }
        text = text.toLowerCase();
        Matcher matcher = URL_PATTERN.matcher(text);
        return matcher.find();
    }

    public static String getDataBaseNameByUrl(String jdbcUrl, String username) {
        int pos1;
        String database = null;
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:oracle")) {
            return username;
        }
        if (jdbcUrl.startsWith("jdbc:impala")) {
            jdbcUrl = jdbcUrl.replace(":impala", "");
        }
        if (!jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if (jdbcUrl.contains("log4jdbc:") && (pos1 = jdbcUrl.indexOf(58, 14)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String connUri = jdbcUrl.substring(pos1 + 1);
        if (connUri.startsWith(DOUBLE_DIAGONAL)) {
            int pos = connUri.indexOf(47, 2);
            if (pos != -1) {
                database = connUri.substring(pos + 1);
            } else {
                pos = connUri.indexOf("databasename=", 2);
                if (pos != -1) {
                    database = connUri.substring(pos + 1);
                }
            }
        } else {
            database = connUri;
        }
        if (database.contains("?")) {
            database = database.substring(0, database.indexOf("?"));
        }
        if (database.contains(";")) {
            database = database.substring(0, database.indexOf(";"));
        }
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        return database;
    }

    public static String firstToUpperCase(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        char firstChar = chars[0];
        if (firstChar >= 'a' && firstChar <= 'z') {
            chars[0] = (char)(chars[0] - 32);
            return String.valueOf(chars);
        }
        return str;
    }

    public static String getRandomStr(int length) {
        StringBuilder val = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val.append((char)(choice + random.nextInt(26)));
                continue;
            }
            val.append(String.valueOf(random.nextInt(10)));
        }
        return val.toString();
    }

    public static void main(String[] args) {
        String randomStr = StrUtil.getRandomStr(10);
        System.out.println(randomStr);
    }
}

