/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import java.security.PrivateKey;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class SmUtil
extends cn.hutool.crypto.SmUtil {
    public static final String SM2_PUBLIC_KEY = "04AF0FCC45059AA342221352E5268614F2FF7A430497B156C0DEE6E751AB44E4957E9E69299E2CD38E25985B7BD34E0E7BBA683DE4725A6A8CD07E19BFF8BEF44D";
    public static final String SM2_PRIVATE_KEY = "00ED5BC2B0A15FD60828BCDCEE03423A538DDA70E4B3D3754CAD5828689AB6ADDD";

    public static SM2 defaultSm2() {
        SM2 sm2 = SmUtil.sm2((String)SM2_PRIVATE_KEY, (String)SM2_PUBLIC_KEY);
        sm2.setMode(SM2Engine.Mode.C1C2C3);
        return sm2;
    }

    public static String sm2DecryptStr(String data) {
        return SmUtil.defaultSm2().decryptStr(data, KeyType.PrivateKey);
    }

    public static String sm2EncryptHex(String data) {
        return SmUtil.defaultSm2().encryptHex(data, KeyType.PublicKey);
    }

    public static String sm2EncryptHex(byte[] data) {
        return SmUtil.defaultSm2().encryptHex(data, KeyType.PublicKey);
    }

    public static boolean sm3Matches(CharSequence rawData, String encodedData) {
        return encodedData.equals(SmUtil.sm3((String)String.valueOf(rawData)));
    }

    public static void main(String[] args) {
        SmUtil.createSm2KeyTest();
    }

    private static void createSm2KeyTest() {
        String text = "\u6211\u662f\u4e00\u6bb5\u6d4b\u8bd5aaaa";
        SM2 sm2 = cn.hutool.crypto.SmUtil.sm2();
        byte[] privateKey = BCUtil.encodeECPrivateKey((PrivateKey)sm2.getPrivateKey());
        byte[] publicKey = ((BCECPublicKey)sm2.getPublicKey()).getQ().getEncoded(false);
        System.out.println("\u79c1\u94a5: " + HexUtil.encodeHexStr((byte[])privateKey));
        System.out.println("\u516c\u94a5: " + HexUtil.encodeHexStr((byte[])publicKey));
        byte[] dateBytes = text.getBytes();
        System.out.println("\u6570\u636e: " + HexUtil.encodeHexStr((byte[])dateBytes));
        sm2.setMode(SM2Engine.Mode.C1C2C3);
        sm2.setEncoding((DSAEncoding)new PlainDSAEncoding());
        byte[] sign = sm2.sign(dateBytes, null);
        System.out.println("\u7b7e\u540d: " + HexUtil.encodeHexStr((byte[])sign));
        boolean verify = sm2.verify(dateBytes, sign);
        System.out.println(verify);
        String encryptHex = sm2.encryptHex("123456", KeyType.PublicKey);
        System.out.println("\u52a0\u5bc6\uff1a" + encryptHex);
        String decryptStr = sm2.decryptStr(encryptHex, KeyType.PrivateKey);
        System.out.println("\u89e3\u5bc6\uff1a" + decryptStr);
    }
}

