/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtil {
    public static final Logger log = LoggerFactory.getLogger(ResponseUtil.class);

    public static void renderJson(HttpServletResponse response, String text) {
        ResponseUtil.render(response, "application/json;charset=UTF-8", text);
    }

    public static void render(HttpServletResponse response, String contentType, String text) {
        response.setContentType(contentType);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("access-control-allow-methods", "POST, GET,HEAD, OPTIONS,PATCH, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with,Authorization");
        response.setHeader("access-control-allow-credentials", "true");
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

