/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.io.IoUtil;
import com.jeecms.utils.spring.SpringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.springframework.boot.system.ApplicationHome;

public class ResourceLoaderUtil {
    public static String appHome() {
        ApplicationHome home = new ApplicationHome();
        return home.getDir().getAbsolutePath() + File.separator;
    }

    public static InputStream loadExtResource(String filename) {
        String appHome = SpringUtil.appHome();
        System.out.println(appHome);
        try {
            return new FileInputStream(appHome + filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static InputStream loadClasspathResource(String resourceName) {
        return ResourceLoaderUtil.class.getClassLoader().getResourceAsStream(resourceName);
    }

    public static InputStream loadResource(String resourceName) {
        InputStream in = ResourceLoaderUtil.loadExtResource(resourceName);
        return in == null ? ResourceLoaderUtil.loadClasspathResource(resourceName) : in;
    }

    public static String loadResourceStr(String resourceName) {
        try {
            byte[] bytes = IoUtil.readBytes((InputStream)ResourceLoaderUtil.loadResource(resourceName));
            return new String(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }
}

