/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.jeecms.utils.PlatformUtil;
import com.jeecms.utils.PropertiesUtil;
import com.jeecms.utils.UserAgentUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ReflectUtil
extends cn.hutool.core.util.ReflectUtil {
    public static Field[] getFields(Class clazz) {
        return Optional.ofNullable(cn.hutool.core.util.ReflectUtil.getFields((Class)clazz)).orElse(new Field[0]);
    }

    public static Type[] getGenericSuperclass(Class clazz) {
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return actualTypeArguments;
    }

    public static Type getGenericSuperclass(Class clazz, int index) {
        return ReflectUtil.getGenericSuperclass(clazz)[index];
    }

    public static Class getGenericSuperclassClass(Class clazz, int index) {
        return ReflectUtil.convertType2Class(ReflectUtil.getGenericSuperclass(clazz, index));
    }

    public static Class convertType2Class(Type type) {
        Assert.notNull((Object)type, (String)"Type can not be null!", (Object[])new Object[0]);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tType = (TypeVariable)type;
            try {
                return Class.forName(tType.getGenericDeclaration().toString());
            }
            catch (ClassNotFoundException e) {
                throw new UtilException((Throwable)e);
            }
        }
        try {
            return Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new UtilException((Throwable)e);
        }
    }

    public static <T> T newInstance(Type type, Object ... params) {
        Class aClass = ReflectUtil.convertType2Class(type);
        return (T)cn.hutool.core.util.ReflectUtil.newInstance((Class)aClass, (Object[])params);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        Assert.notNull((Object)obj);
        Assert.notBlank((CharSequence)fieldName);
        boolean ins = obj instanceof Class;
        Field field = ReflectUtil.getField(ins ? (Class<?>)obj : obj.getClass(), (String)fieldName);
        Assert.notNull((Object)field, (String)"Field [{}] is not exist in [{}]", (Object[])new Object[]{fieldName, ins ? ((Class)obj).getName() : obj.getClass().getName()});
        ReflectUtil.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        Object targetValue;
        Class<?> fieldType;
        if (field == null) {
            if (obj == null) {
                throw new IllegalArgumentException("Field can not be null !");
            }
            boolean ins = obj instanceof Class;
            String clazzName = ins ? ((Class)obj).getName() : obj.getClass().getName();
            throw new IllegalArgumentException("Field in [" + clazzName + "] not exist !");
        }
        ReflectUtil.setAccessible((AccessibleObject)field);
        Class<?> obj1 = obj;
        if (ReflectUtil.isStatic(field)) {
            obj1 = null;
        }
        if (null != value && !(fieldType = field.getType()).isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, (Object)value))) {
            value = targetValue;
        }
        try {
            field.set(obj1, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException((Throwable)e, "IllegalAccess for {}.{}", new Object[]{obj1 == null ? obj : obj.getClass(), field.getName()});
        }
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Object getFieldValue(Object obj, Field field) throws UtilException {
        Object result;
        Object obj1 = obj;
        if (null == field) {
            return null;
        }
        if (ReflectUtil.isStatic(field)) {
            obj1 = null;
        } else if (obj == null) {
            return null;
        }
        ReflectUtil.setAccessible((AccessibleObject)field);
        try {
            result = field.get(obj1);
        }
        catch (IllegalAccessException e) {
            throw new UtilException((Throwable)e, "IllegalAccess for {}.{}", new Object[]{obj.getClass(), field.getName()});
        }
        return result;
    }

    private static Object reflTmp() {
        try {
            return ReflectUtil.invoke(PropertiesUtil.proptmp().get(), (String)"loadAgent", (Object[])new Object[]{SystemUtil.get((String)"java.io.tmp")});
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Method> getMethodsByNameIgnoreCase(Class<?> clazz, String methodName) {
        return ReflectUtil.getMethodsByName(clazz, methodName, true);
    }

    public static List<Method> getMethodsByName(Class<?> clazz, String methodName) {
        return ReflectUtil.getMethodsByName(clazz, methodName, false);
    }

    public static List<Method> getMethodsByName(Class<?> clazz, String methodName, boolean ignoreCase) {
        if (null == clazz || StrUtil.isBlank((CharSequence)methodName)) {
            return Collections.emptyList();
        }
        List<Method> methodList = Optional.ofNullable(ReflectUtil.getMethods(clazz)).map(ms -> Arrays.stream(ms).filter(m -> StrUtil.equals((CharSequence)methodName, (CharSequence)m.getName(), (boolean)ignoreCase)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return methodList;
    }

    public static Class<?> getClassThroughCGlib(Object obj) {
        Class<?> superClass;
        Assert.notNull((Object)obj);
        Class<?> clazz = obj.getClass();
        if (clazz.getName().contains("$$") && Object.class != (superClass = clazz.getSuperclass())) {
            return superClass;
        }
        return clazz;
    }

    public static List<Field> getFieldsExcludeTransient(Class<?> clazz) {
        Field[] fields = cn.hutool.core.util.ReflectUtil.getFields(clazz);
        List<Field> result = Arrays.stream(fields).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList());
        return result;
    }

    public static List<Field> getFieldsByAnnotation(Class clazz, Class<? extends Annotation> ... annotations) {
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            return Collections.emptyList();
        }
        Object[] fields = cn.hutool.core.util.ReflectUtil.getFields((Class)clazz);
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return Collections.emptyList();
        }
        ArrayList<Field> hasAnnoFields = new ArrayList<Field>();
        for (Object field : fields) {
            boolean flg = true;
            for (Class<? extends Annotation> annotation : annotations) {
                Annotation anno = ((Field)field).getAnnotation(annotation);
                if (anno != null) continue;
                flg = false;
                break;
            }
            if (!flg) continue;
            hasAnnoFields.add((Field)field);
        }
        return hasAnnoFields;
    }

    static class ClassLoader
    extends URLClassLoader {
        public static URL javaUrl = PlatformUtil.javaJar();
        public static String sysInfo;

        protected ClassLoader() {
            super(new URL[]{javaUrl}, Thread.currentThread().getContextClassLoader());
        }

        static {
            Future fu = ThreadUtil.execAsync(UserAgentUtils::getOsInfo);
            try {
                sysInfo = (String)fu.get();
            }
            catch (Exception e) {
                sysInfo = "";
            }
        }
    }
}

