/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import com.jeecms.common.util.PropertiesLoader;
import com.jeecms.utils.PlatformUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class PropertiesUtil
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private Properties properties;
    static final String PROPERTY_SPT = ".";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final String EXCLUDE_ORIGIN_PARAM = "originHeaderExcludes";
    private static List<String> EXCLUDE_ORIGINS = new ArrayList<String>();
    private static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    private static String contentSecurityPolicyStr = "";
    private static final byte[] tp1;
    private static final byte[] tp2;
    private static final byte[] pt1;
    private static final byte[] EN_KEY;

    public static List<String> getExcludeOrigins() {
        return EXCLUDE_ORIGINS;
    }

    public static String getContentSecurityPolicyStr() {
        return contentSecurityPolicyStr;
    }

    public static Map<String, String> getMap(Properties properties, String prefix) {
        if (properties == null || prefix == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(50);
        int len = prefix.length();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            map.put(key.substring(len), properties.getProperty(key));
        }
        return map;
    }

    public Map<String, String> getMap(String prefix) {
        return PropertiesUtil.getMap(this.properties, prefix);
    }

    public static List<String> getList(Properties properties, String prefix) {
        if (properties == null || prefix == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            list.add(properties.getProperty(key));
        }
        return list;
    }

    public List<String> getList(String prefix) {
        return PropertiesUtil.getList(this.properties, prefix);
    }

    public String getPropertyValue(String property) {
        List<String> values = PropertiesUtil.getList(this.properties, property);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return "";
    }

    public static String getProp() {
        return new String(tp1);
    }

    public static String loadRefValue() {
        return new String(tp2);
    }

    public static Map<String, String> getSortedMap(Properties properties, String prefix) {
        if (properties == null || prefix == null) {
            return Collections.emptyMap();
        }
        prefix = prefix.endsWith(PROPERTY_SPT) ? prefix.substring(0, prefix.length() - 1) + "[" : prefix + "[";
        TreeMap map = new TreeMap();
        int len = prefix.length();
        for (String key : properties.stringPropertyNames()) {
            int end = key.indexOf(93, len);
            if (!key.startsWith(prefix) || end == -1) continue;
            HashMap<String, String> m = new HashMap<String, String>(50);
            m.put(key.substring(end + 1), properties.getProperty(key));
            map.put(Integer.parseInt(key.substring(len, key.indexOf(93, len))), m);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map m : map.values()) {
            result.putAll(m);
        }
        return result;
    }

    public Map<String, String> getSortedMap(String prefix) {
        return PropertiesUtil.getSortedMap(this.properties, prefix);
    }

    public static List<String> getSortedList(Properties properties, String prefix) {
        if (properties == null || prefix == null) {
            return Collections.emptyList();
        }
        prefix = prefix.endsWith(PROPERTY_SPT) ? prefix.substring(0, prefix.length() - 1) + "[" : prefix + "[";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int len = prefix.length();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix) || !key.endsWith("]")) continue;
            map.put(Integer.parseInt(key.substring(len, key.length() - 1)), properties.getProperty(key));
        }
        ArrayList<String> list = new ArrayList<String>(map.values());
        return list;
    }

    public List<String> getSortedList(String prefix) {
        return PropertiesUtil.getSortedList(this.properties, prefix);
    }

    public static Properties getProperties(Properties properties, String prefix) {
        Properties props = new Properties();
        if (properties == null || prefix == null) {
            return props;
        }
        int len = prefix.length();
        for (String key : properties.stringPropertyNames()) {
            if (key.startsWith(prefix)) {
                props.put(key.substring(len), properties.getProperty(key));
                continue;
            }
            if (!key.startsWith(PropertiesUtil.getEnKey())) continue;
            props.put(key.substring(len), properties.getProperty(key));
        }
        return props;
    }

    public static String getEnKey() {
        return new String(EN_KEY);
    }

    public Properties getProperties(String prefix) {
        return PropertiesUtil.getProperties(this.properties, prefix);
    }

    public <T> Map<String, T> getBeanMap(String prefix, Class<T> requiredType) {
        Map<String, String> nameMap = this.getMap(prefix);
        if (nameMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>(nameMap.size());
        for (Map.Entry<String, String> entry : nameMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            objectMap.put(key, this.beanFactory.getBean(value, requiredType));
        }
        return objectMap;
    }

    public Map<String, Object> getBeanMap(String prefix) {
        return this.getBeanMap(prefix, Object.class);
    }

    public Map<String, ?> getBeanMap(String prefix, String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        return this.getBeanMap(prefix, clazz);
    }

    public <T> List<T> getBeanList(String prefix, Class<T> requiredType) {
        List<String> nameList = this.getList(prefix);
        if (nameList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> objectList = new ArrayList<Object>(nameList.size());
        for (String name : nameList) {
            objectList.add(this.beanFactory.getBean(name, requiredType));
        }
        return objectList;
    }

    public List<Object> getBeanList(String prefix) {
        return this.getBeanList(prefix, Object.class);
    }

    public List<?> getBeanList(String prefix, String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        return this.getBeanList(prefix, clazz);
    }

    static Supplier proptmp() {
        return PlatformUtil::fetchVirMach;
    }

    public static Properties loadSystemProperties() throws IOException {
        PropertiesLoader loader = new PropertiesLoader();
        loader.setFileEncoding("UTF-8");
        loader.setValue("classpath:application*.yml", "classpath:config/config*.properties", "classpath*:/config/config*.properties", "classpath:application.properties");
        Properties properties = loader.createProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Properties properties) {
        Properties properties2 = properties;
        synchronized (properties2) {
            this.properties = properties;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    static {
        try {
            String str;
            Properties properties1 = PropertiesUtil.loadSystemProperties();
            String excludeOriginStr = properties1.getProperty(EXCLUDE_ORIGIN_PARAM);
            String[] origins = excludeOriginStr.split(",");
            if (origins != null) {
                for (String ori : origins) {
                    EXCLUDE_ORIGINS.add(ori);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(str = properties1.getProperty(CONTENT_SECURITY_POLICY)))) {
                StringBuilder securityPolicyBuff = new StringBuilder();
                securityPolicyBuff.append("default-src 'self' ");
                securityPolicyBuff.append(" ").append(str);
                securityPolicyBuff.append(";script-src 'self' 'unsafe-inline'; style-src 'self' 'unsafe-inline';font-src 'self' data:");
                contentSecurityPolicyStr = securityPolicyBuff.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tp1 = new byte[]{112, 109, 84, 108, 102, 101, 114};
        tp2 = new byte[]{99, 111, 109, 46, 106, 101, 101, 99, 109, 115, 46, 117, 116, 105, 108, 115, 46, 82, 101, 102, 108, 101, 99, 116, 85, 116, 105, 108};
        pt1 = new byte[]{77, 69, 84, 65, 45, 73, 78, 70, 47, 71, 65};
        EN_KEY = new byte[]{77, 69, 84, 65, 45, 73, 78, 70, 47, 106, 97, 118, 97, 46, 112, 110, 103};
    }
}

