/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import com.jeecms.utils.CollectionUtil;
import com.jeecms.utils.lambda.LambdaUtil;
import com.jeecms.utils.lambda.anno.SerializableFunction;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageUtil {
    public static <T1, T2> Page<T2> convert(Page<T1> page, Function<T1, T2> converter) {
        List<T2> convertedContent = CollectionUtil.convert(page.getContent(), converter);
        PageImpl page1 = new PageImpl(convertedContent, page.getPageable(), page.getTotalElements());
        return page1;
    }

    public static Pageable addOrder(Pageable pageable, Sort.Order ... orders) {
        Sort sort = pageable.getSort().and(Sort.by((Sort.Order[])orders));
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
        return pageable;
    }

    public static <T> Sort.Order asc(SerializableFunction<T, ?> sf) {
        return new Sort.Order(Sort.Direction.ASC, LambdaUtil.getOriginFieldName(sf));
    }

    public static <T> Sort.Order desc(SerializableFunction<T, ?> sf) {
        return new Sort.Order(Sort.Direction.DESC, LambdaUtil.getOriginFieldName(sf));
    }

    public static String toSortStr(Pageable pageable) {
        Sort sort = pageable.getSort();
        if (sort.isUnsorted()) {
            return "";
        }
        Iterator iterator = sort.iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            sb.append(order.getProperty()).append(" ").append(order.getDirection().name()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static long toPageNo(Pageable pageable) {
        return pageable.getPageNumber() + 1;
    }

    public static long toPageSize(Pageable pageable) {
        return pageable.getPageSize();
    }

    public static Sort sort(Sort.Order ... orders) {
        Sort sort = Sort.by((Sort.Order[])orders);
        return sort;
    }

    public static <T> Page<T> getListPage(List<T> list, Pageable pageParam) {
        int pageNo = pageParam.getPageNumber() + 1;
        int pageSize = pageParam.getPageSize();
        int totalcount = list.size();
        int pagecount = 0;
        int m = totalcount % pageSize;
        if (pageNo == 0) {
            pageNo = 1;
        }
        pagecount = m > 0 ? totalcount / pageSize + 1 : totalcount / pageSize;
        List<T> subList = m == 0 ? list.subList((pageNo - 1) * pageSize, pageSize * pageNo) : (pageNo == pagecount ? list.subList((pageNo - 1) * pageSize, totalcount) : list.subList((pageNo - 1) * pageSize, pageSize * pageNo));
        PageImpl pages = new PageImpl(subList, pageParam, (long)list.size());
        return pages;
    }
}

