/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil
extends cn.hutool.core.net.NetUtil {
    private static final Logger log = LoggerFactory.getLogger(NetUtil.class);
    private static final Pattern IP_PATTERN = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
    public static String PATTERN_L2DOMAIN = "\\w*\\.\\w*:";
    public static String PATTERN_IP = "(\\d*\\.){3}\\d*";

    public static boolean isInnerIP(String ip) {
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        return cn.hutool.core.net.NetUtil.isInnerIP((String)ip);
    }

    public static boolean ping(String target, int timeout) {
        boolean status = false;
        if (target != null) {
            try {
                status = InetAddress.getByName(target).isReachable(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    public static String getInternetIp() {
        String ip = NetUtil.getInternetIp1();
        if (ip != null) {
            return ip;
        }
        ip = NetUtil.getInternetIp5();
        if (ip != null) {
            return ip;
        }
        ip = NetUtil.getInternetIp2();
        if (ip != null) {
            return ip;
        }
        ip = NetUtil.getInternetIp3();
        if (ip != null) {
            return ip;
        }
        ip = NetUtil.getInternetIp4();
        if (ip != null) {
            return ip;
        }
        return null;
    }

    private static String getInternetIp1() {
        String ip = null;
        try {
            String post = HttpUtil.post((String)"http://pv.sohu.com/cityjson?ie=utf-8", (String)"");
            JSONObject jo = JSONObject.parseObject((String)post.substring(19, post.length() - 1));
            ip = (String)jo.get((Object)"cip");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    private static String getInternetIp2() {
        String ip = null;
        try {
            ip = HttpUtil.get((String)"http://ip.42.pl/raw");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    private static String getInternetIp3() {
        String ip = null;
        try {
            String ret = HttpUtil.get((String)"http://httpbin.org/ip");
            JSONObject jo = JSONObject.parseObject((String)ret);
            ip = jo.getString("origin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    private static String getInternetIp4() {
        String ip = null;
        try {
            String ret = HttpUtil.get((String)"https://api.ipify.org/?format=json");
            JSONObject jo = JSONObject.parseObject((String)ret);
            ip = jo.getString("ip");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    private static String getInternetIp5() {
        String ip = null;
        try {
            URL url = new URL("http://202020.ip138.com");
            URLConnection urlconn = url.openConnection();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));){
                String buf;
                StringBuilder sb = new StringBuilder();
                while ((buf = br.readLine()) != null) {
                    sb.append(buf);
                }
                Matcher matcher = IP_PATTERN.matcher(sb);
                if (matcher.find()) {
                    ip = matcher.group(1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    public static String getIpLocation(String ip) {
        try {
            String body = ((HttpRequest)HttpRequest.get((String)String.format("https://apis.map.qq.com/ws/location/v1/ip?ip=%s&key=OB4BZ-D4W3U-B7VVO-4PJWW-6TKDJ-WPB77", ip)).header("Referer", "https://lbs.qq.com/service/webService/webServiceGuide/webServiceIp")).execute().body();
            JSONObject jo = JSONObject.parseObject((String)body);
            if (jo.getIntValue("status") == 0) {
                JSONObject result = jo.getJSONObject("result");
                JSONObject adInfo = result.getJSONObject("ad_info");
                String location = Arrays.asList(adInfo.getString("nation"), adInfo.getString("province"), adInfo.getString("city"), adInfo.getString("district")).stream().distinct().filter(StringUtils::isNotBlank).filter(s -> !"\u4e2d\u56fd".equals(s)).collect(Collectors.joining());
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static boolean isIp(String ip) {
        return ip.matches("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");
    }

    public static String getCookieDomain(String url) {
        Pattern ipPattern = Pattern.compile(PATTERN_IP);
        Matcher matcher = ipPattern.matcher(url);
        if (matcher.find()) {
            System.out.println("[HttpUtil][getCookieDomain] match ip.");
            return matcher.group();
        }
        Pattern pattern = Pattern.compile(PATTERN_L2DOMAIN);
        matcher = pattern.matcher(url);
        if (matcher.find()) {
            System.out.println("[HttpUtil][getCookieDomain] match domain.");
            String domain = matcher.group();
            return domain.substring(0, domain.length() - 1);
        }
        return null;
    }

    public static String localIpv4() {
        try {
            LinkedHashSet<InetAddress> inetAddresses = NetUtil.localIpv4AddressList();
            InetAddress next = (InetAddress)inetAddresses.iterator().next();
            return next.getHostAddress();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static LinkedHashSet<InetAddress> localIpv4AddressList() throws SocketException {
        return NetUtil.localAddressList(t -> t instanceof Inet4Address);
    }

    public static String getHostIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    System.out.println("\u672c\u673a\u7684IP = " + ip.getHostAddress());
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

