/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import com.jeecms.utils.Assert;
import java.math.BigDecimal;

public class MathUtil
extends cn.hutool.core.math.MathUtil {
    public static final int SCALE_LEN_COMMON = 2;
    public static final String RADIX_TABLE = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!$";

    public static BigDecimal formatScale(String value) {
        return new BigDecimal(value).setScale(2, 4);
    }

    public static BigDecimal formatScale(String value, int scale) {
        return new BigDecimal(value).setScale(scale, 4);
    }

    public static BigDecimal formatScale(String value, int scale, int roundingMode) {
        return new BigDecimal(value).setScale(scale, roundingMode);
    }

    public static BigDecimal formatScaleCast(String value, int scale) {
        return new BigDecimal(value).setScale(scale, 1);
    }

    public static BigDecimal formatScaleCast(BigDecimal value, int scale) {
        return value.setScale(scale, 1);
    }

    public static BigDecimal formatScaleCommon(BigDecimal value) {
        return value.setScale(2, 1);
    }

    public static BigDecimal add(BigDecimal value1, BigDecimal value2) {
        return value1.add(value2);
    }

    public static BigDecimal sub(BigDecimal value1, BigDecimal value2) {
        return value1.subtract(value2);
    }

    public static BigDecimal mul(BigDecimal value1, BigDecimal value2) {
        return value1.multiply(value2);
    }

    public static BigDecimal div(BigDecimal value1, BigDecimal value2, int scale) throws IllegalAccessException {
        if (scale < 0) {
            throw new IllegalAccessException("\u7cbe\u786e\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (value2.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return value1.divide(value2, scale, 0);
    }

    public static BigDecimal divToScaleCommon(BigDecimal value1, BigDecimal value2) {
        return value1.divide(value2, 2, 1);
    }

    public static String convertRadix(String numStr, int radix) {
        return MathUtil.convertRadix(numStr, 10, radix);
    }

    public static String convertRadix(String numStr, int radix1, int radix2) {
        return MathUtil.convertRadix(numStr, radix1, radix2, RADIX_TABLE);
    }

    public static String convertRadix(String numStr, int radix1, int radix2, String radixTable) {
        long t;
        Assert.notNull((Object)radixTable);
        if (radixTable.length() < radix2) {
            throw new IllegalArgumentException("\u8fdb\u5236\u8868\u4e0d\u7b26\u5408" + radix2 + "\u8fdb\u5236");
        }
        if (radix1 == radix2) {
            return numStr;
        }
        boolean negative = false;
        char[] c1 = numStr.toCharArray();
        int i = 0;
        if (radixTable.indexOf(c1[0]) == -1) {
            if (c1[0] == '-') {
                negative = true;
            } else if (c1[0] != '+') {
                throw new NumberFormatException("For input string: \"" + numStr + "\"");
            }
            if (c1.length == 1) {
                throw new NumberFormatException("For input string: \"" + numStr + "\"");
            }
            i = 1;
        }
        StringBuilder sb = new StringBuilder();
        long num = 0L;
        while (i < c1.length) {
            t = radixTable.indexOf(c1[i]);
            if (t < 0L) {
                throw new NumberFormatException("For input string: \"" + numStr + "\"");
            }
            num = num * (long)radix1 + t;
            ++i;
        }
        do {
            t = num % (long)radix2;
            sb.append(radixTable.charAt((int)t));
        } while ((num /= (long)radix2) != 0L);
        if (negative) {
            sb.append("-");
        }
        return sb.reverse().toString();
    }

    public static int min(int ... nums) {
        int min = Integer.MAX_VALUE;
        for (int num : nums) {
            min = Math.min(min, num);
        }
        return min;
    }

    public static int max(int ... nums) {
        int max = Integer.MIN_VALUE;
        for (int num : nums) {
            max = Math.max(max, num);
        }
        return max;
    }

    public static double round(double middle, int precision) {
        BigDecimal bigDecimal = BigDecimal.valueOf(middle);
        return bigDecimal.setScale(precision, 4).doubleValue();
    }
}

