/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.collection.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LockUtil
extends cn.hutool.core.thread.lock.LockUtil {
    private static final Map<Object, ReentrantLock> lockMap = new ConcurrentHashMap<Object, ReentrantLock>();
    private static final Set<Object> getLockFlagMap = new ConcurrentHashSet();
    private static final ReentrantLock lock = new ReentrantLock();

    public static boolean tryLock(Object obj) {
        try {
            lock.lock();
            ReentrantLock lockForObj = lockMap.computeIfAbsent(obj, o -> new ReentrantLock());
            boolean bl = lockForObj.tryLock();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void lock(Object obj) {
        ReentrantLock lockForObj;
        try {
            lock.lock();
            lockForObj = lockMap.computeIfAbsent(obj, o -> new ReentrantLock());
            getLockFlagMap.add(obj);
        }
        finally {
            lock.unlock();
        }
        try {
            lockForObj.lock();
        }
        finally {
            getLockFlagMap.remove(obj);
        }
    }

    public static void unlock(Object obj) {
        try {
            lock.lock();
            ReentrantLock lockForObj = lockMap.computeIfAbsent(obj, o -> new ReentrantLock());
            lockForObj.unlock();
            if (lockForObj.getQueueLength() <= 0 && !getLockFlagMap.contains(obj)) {
                lockMap.remove(obj);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void main(String[] args) {
    }
}

