/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer status;
    private String message;
    private LocationResult result;

    public LocationResult getResult() {
        return this.result;
    }

    public void setResult(LocationResult result) {
        this.result = result;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public LocationResult getLocationResult() {
        return new LocationResult();
    }

    public String getCityCode(String adCode) {
        return StringUtils.isNotBlank((CharSequence)adCode) && adCode.length() >= 4 ? adCode.substring(0, 4) + "00" : "";
    }

    public String getProvinceCode(String adCode) {
        return StringUtils.isNotBlank((CharSequence)adCode) && adCode.length() >= 2 ? adCode.substring(0, 2) + "0000" : "";
    }

    public class LocationResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String ip;
        private Locat location;
        private AdInfo adInfo;

        public LocationResult() {
            this.setAdInfo(new AdInfo());
            this.setLocation(new Locat());
        }

        public LocationResult(String ip, Locat location, AdInfo adInfo) {
            this.ip = ip;
            this.location = location;
            this.adInfo = adInfo;
        }

        public Locat setLocat(Double lng, Double lat) {
            Locat location = this.getLocation();
            location.setLat(lat);
            location.setLng(lng);
            return location;
        }

        public AdInfo setAdInfo(String nation, String province, String city, String district, String adcode) {
            AdInfo info = this.getAdInfo();
            info.setAdcode(adcode);
            info.setCity(city);
            info.setDistrict(district);
            info.setNation(nation);
            info.setProvince(province);
            return info;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Locat getLocation() {
            return this.location;
        }

        public void setLocation(Locat location) {
            this.location = location;
        }

        public AdInfo getAdInfo() {
            return this.adInfo;
        }

        public void setAdInfo(AdInfo adInfo) {
            this.adInfo = adInfo;
        }

        public class AdInfo
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private String nation;
            private String province;
            private String city;
            private String district;
            private String adcode;

            public String getNation() {
                return this.nation;
            }

            public void setNation(String nation) {
                this.nation = nation;
            }

            public String getProvince() {
                return this.province;
            }

            public void setProvince(String province) {
                this.province = province;
            }

            public String getCity() {
                return this.city;
            }

            public void setCity(String city) {
                this.city = city;
            }

            public String getDistrict() {
                return this.district;
            }

            public void setDistrict(String district) {
                this.district = district;
            }

            public String getAdcode() {
                return this.adcode;
            }

            public void setAdcode(String adcode) {
                this.adcode = adcode;
            }

            public AdInfo(String nation, String province, String city, String district, String adcode) {
                this.nation = nation;
                this.province = province;
                this.city = city;
                this.district = district;
                this.adcode = adcode;
            }

            public AdInfo() {
            }
        }

        public class Locat
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Double lng;
            private Double lat;

            public Double getLng() {
                return this.lng;
            }

            public void setLng(Double lng) {
                this.lng = lng;
            }

            public Double getLat() {
                return this.lat;
            }

            public void setLat(Double lat) {
                this.lat = lat;
            }

            public Locat(Double lng, Double lat) {
                this.lng = lng;
                this.lat = lat;
            }

            public Locat() {
            }
        }
    }
}

