/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Singleton;
import com.jeecms.lang.Sequence;
import com.jeecms.utils.MathUtil;
import java.time.LocalDateTime;

public class IdUtil
extends cn.hutool.core.util.IdUtil {
    public static Sequence createSequence(long workerId, long datacenterId) {
        return new Sequence(workerId, datacenterId);
    }

    public static Sequence getSequence(long workerId, long datacenterId) {
        return (Sequence)Singleton.get(Sequence.class, (Object[])new Object[]{workerId, datacenterId});
    }

    public static Sequence getSequence() {
        return (Sequence)Singleton.get(Sequence.class, (Object[])new Object[0]);
    }

    public static long getId() {
        return IdUtil.getSequence().nextId();
    }

    public static String getIdStr() {
        return Long.toBinaryString(IdUtil.getId());
    }

    public static String getMillisecond() {
        return DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmssSSS");
    }

    public static String getTimeId() {
        return IdUtil.getMillisecond() + IdUtil.getIdStr();
    }

    public static String get32UUID() {
        return IdUtil.fastSimpleUUID();
    }

    public static String shortSequenceId(long id) {
        String shortId = MathUtil.convertRadix(Long.toString(id - 1200000000000000000L), 62);
        return shortId;
    }

    public static long stretchShortSequenceId(String shortSequenceId) {
        return Long.parseLong(MathUtil.convertRadix(shortSequenceId, 62, 10)) + 1200000000000000000L;
    }
}

