/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.bean.copier.BeanCopier;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ArrayUtil;
import com.jeecms.utils.BeanUtil;
import com.jeecms.utils.ReflectUtil;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class HibernateUtil {
    private static final Map<Class, String[]> updateIgnorePropertiesMap = new ConcurrentHashMap<Class, String[]>();

    public static Object loadHibernateProxy(Object object) {
        PersistentCollection collection;
        if (object instanceof HibernateProxy) {
            try {
                object = HibernateUtil.deProxy(object);
            }
            catch (Exception e) {
                return object;
            }
        }
        if (object instanceof PersistentCollection && !(collection = (PersistentCollection)object).wasInitialized()) {
            collection.forceInitialization();
        }
        return object;
    }

    public static <T> T deProxy(T obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)obj;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            return (T)li.getImplementation();
        }
        return obj;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Object originObj = HibernateUtil.deProxy(obj);
        Object fieldValue = ReflectUtil.getFieldValue((Object)originObj, (String)fieldName);
        return fieldValue;
    }

    public static void setFieldValue(Object obj, String fieldName, Object val) {
        Object originObj = HibernateUtil.deProxy(obj);
        ReflectUtil.setFieldValue(originObj, fieldName, val);
    }

    public static Object getProperty(Object obj, String expression) {
        Object originObj = HibernateUtil.deProxy(obj);
        Object property = BeanUtil.getProperty((Object)originObj, (String)expression);
        return property;
    }

    public static void setProperty(Object obj, String expression, Object value) {
        Object originObj = HibernateUtil.deProxy(obj);
        BeanUtil.setProperty((Object)originObj, (String)expression, (Object)value);
    }

    public static void copyUpdatePropertiesValue(Object source, Object target) {
        BeanCopier.create((Object)source, (Object)target, (CopyOptions)CopyOptions.create().ignoreNullValue().setIgnoreProperties(HibernateUtil.getNoCascadeProperties(source.getClass()))).copy();
    }

    private static String[] getNoCascadeProperties(Class cls) {
        String[] props = updateIgnorePropertiesMap.get(cls);
        if (props == null) {
            Method[] methods;
            Field[] fields;
            ArrayList<String> propNames = new ArrayList<String>();
            for (Field field : fields = ReflectUtil.getFields(cls)) {
                Object[] oneToMany = (OneToMany[])field.getAnnotationsByType(OneToMany.class);
                if (ArrayUtil.isNotEmpty((Object[])oneToMany) && ArrayUtil.isEmpty((Object[])oneToMany[0].cascade())) {
                    propNames.add(field.getName());
                    continue;
                }
                Object[] manyToOne = (ManyToOne[])field.getAnnotationsByType(ManyToOne.class);
                if (ArrayUtil.isNotEmpty((Object[])manyToOne) && ArrayUtil.isEmpty((Object[])manyToOne[0].cascade())) {
                    propNames.add(field.getName());
                    continue;
                }
                Object[] manyToMany = (ManyToMany[])field.getAnnotationsByType(ManyToMany.class);
                if (!ArrayUtil.isNotEmpty((Object[])manyToMany) || !ArrayUtil.isEmpty((Object[])manyToMany[0].cascade())) continue;
                propNames.add(field.getName());
            }
            for (Method method : methods = ReflectUtil.getMethods((Class)cls)) {
                Object[] oneToMany = (OneToMany[])method.getAnnotationsByType(OneToMany.class);
                if (ArrayUtil.isNotEmpty((Object[])oneToMany) && ArrayUtil.isEmpty((Object[])oneToMany[0].cascade())) {
                    propNames.add(HibernateUtil.methodNameToPropertyName(method.getName()));
                    continue;
                }
                Object[] manyToOne = (ManyToOne[])method.getAnnotationsByType(ManyToOne.class);
                if (ArrayUtil.isNotEmpty((Object[])manyToOne) && ArrayUtil.isEmpty((Object[])manyToOne[0].cascade())) {
                    propNames.add(HibernateUtil.methodNameToPropertyName(method.getName()));
                    continue;
                }
                Object[] manyToMany = (ManyToMany[])method.getAnnotationsByType(ManyToMany.class);
                if (!ArrayUtil.isNotEmpty((Object[])manyToMany) || !ArrayUtil.isEmpty((Object[])manyToMany[0].cascade())) continue;
                propNames.add(HibernateUtil.methodNameToPropertyName(method.getName()));
            }
            updateIgnorePropertiesMap.put(cls, propNames.toArray(new String[0]));
            props = updateIgnorePropertiesMap.get(cls);
        }
        return props;
    }

    private static String methodNameToPropertyName(String methodName) {
        return Introspector.decapitalize(methodName.substring(3));
    }
}

