/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GsonUtils {
    private static final Gson gson = new Gson();

    private GsonUtils() {
    }

    public static String gsonString(Object object) {
        String gsonString = null;
        if (gson != null) {
            gsonString = gson.toJson(object);
        }
        return gsonString;
    }

    public static <T> T gsonToBean(String gsonString, Class<T> cls) {
        Object t = null;
        if (gson != null) {
            t = gson.fromJson(gsonString, cls);
        }
        return (T)t;
    }

    public static <T> List<T> gsonToList(String json, Class<T> cls) {
        ArrayList<Object> list = new ArrayList<Object>();
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        for (JsonElement elem : array) {
            list.add(gson.fromJson(elem, cls));
        }
        return list;
    }

    public static <T> Set<T> gsonToSet(String json, Class<T> cls) {
        HashSet<Object> list = new HashSet<Object>();
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        for (JsonElement elem : array) {
            list.add(gson.fromJson(elem, cls));
        }
        return list;
    }

    public static Map<Long, Integer> gsonToMaps(String gsonString) {
        Map map = null;
        if (gson != null) {
            map = (Map)gson.fromJson(gsonString, new TypeToken<Map<Long, Integer>>(){}.getType());
        }
        return map;
    }
}

