/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import com.google.common.collect.Sets;
import com.jeecms.utils.FileTypeUtil;
import com.jeecms.utils.lambda.LambdaUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil
extends cn.hutool.core.io.FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    static final String SPECIAL_S1 = "\u0000";
    static final String SPECIAL_S2 = "/";
    static final String SPECIAL_S3 = "\\";
    static final String SPECIAL_S5 = "../";
    static final String SPECIAL_S6 = "..\\";
    static final String SPECIAL_S7 = "|";
    static final String SPECIAL_S8 = "\\|";
    static final String SPECIAL_S9 = "glob:";
    static final String SPECIAL_S10 = "regex:";
    static Integer int1024 = 1024;
    static Float float1024 = Float.valueOf(1024.0f);
    private static Map<String, String> fileTypeMap = new HashMap<String, String>();
    private static Map<String, List<String>> whiteList = new HashMap<String, List<String>>();
    private static List<String> blackList = new ArrayList<String>();

    public static String humanSize(long fileSize) {
        String strFileSize = fileSize < (long)int1024.intValue() ? fileSize + "B" : (fileSize < (long)(int1024 * int1024) ? Math.ceil((float)fileSize / float1024.floatValue() * 100.0f) / 100.0 + "KB" : (fileSize < (long)(int1024 * int1024 * int1024) ? Math.ceil((float)fileSize / ((float)int1024.intValue() * float1024.floatValue()) * 100.0f) / 100.0 + "MB" : Math.ceil((float)fileSize / ((float)(int1024 * int1024) * float1024.floatValue()) * 100.0f) / 100.0 + "GB"));
        return strFileSize;
    }

    public static String humanSize(File file) {
        return FileUtil.humanSize(FileUtil.size((File)file));
    }

    @Deprecated
    public static String getRealType(File file) {
        return FileUtil.getType((File)file);
    }

    @Deprecated
    public static String getRealType(InputStream in) {
        return FileUtil.getType(in);
    }

    public static String getType(InputStream in) {
        return FileTypeUtil.getType((InputStream)in);
    }

    public static File createTempFile(String suffix) {
        File tempFile = FileUtil.createTempFileIn(FileUtil.getTmpDirPath(), suffix);
        return tempFile;
    }

    public static File createTempFileIn(String dir) {
        File tempFile = FileUtil.createTempFile((String)"tempfile", null, (File)new File(dir), (boolean)true);
        return tempFile;
    }

    public static File createTempFileIn(String dir, String suffix) {
        if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        File tempFile = FileUtil.createTempFile((String)"tempfile", (String)suffix, (File)new File(dir), (boolean)true);
        return tempFile;
    }

    public static File createTempFile() {
        File tempFile = FileUtil.createTempFileIn(cn.hutool.core.io.FileUtil.getTmpDirPath(), ".tmp");
        return tempFile;
    }

    public static ByteArrayOutputStream convertInputStreamToByte(InputStream inputStream) {
        try {
            int len;
            ByteArrayOutputStream outByte = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                outByte.write(buffer, 0, len);
            }
            outByte.flush();
            return outByte;
        }
        catch (Exception e) {
            log.debug("\u6587\u4ef6\u6d41\u8f6c\u6362\u51fa\u9519{}", (Object)e.getMessage());
            return null;
        }
    }

    public static void isValidFilename(String basePath, String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new IllegalArgumentException("filename or path is valid!");
        }
        if (filename.contains(SPECIAL_S5) || filename.contains(SPECIAL_S6) || filename.indexOf(SPECIAL_S1) != -1) {
            throw new IllegalArgumentException("filename or path is valid!");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{basePath}) && !filename.startsWith(basePath)) {
            throw new IllegalArgumentException("filename or path is valid!");
        }
    }

    public static String normalizeFilename(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return filename;
        }
        return Normalizer.normalize(filename, Normalizer.Form.NFKD);
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null == src || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static String getFileSuffix(String fileHeaderCode) {
        for (Map.Entry<String, String> entry : fileTypeMap.entrySet()) {
            String key = entry.getKey();
            boolean match = key.length() > fileHeaderCode.length() ? key.toLowerCase().startsWith(fileHeaderCode.toLowerCase()) : fileHeaderCode.toLowerCase().startsWith(key.toLowerCase());
            if (!match) continue;
            return entry.getValue();
        }
        return null;
    }

    private static String getFileHeaderCode(InputStream in) {
        byte[] b = new byte[10];
        String fileCode = "";
        try {
            in.read(b, 0, b.length);
            fileCode = FileUtil.bytesToHexString(b);
        }
        catch (IOException e) {
            log.error("IOException:", (Throwable)e);
        }
        return fileCode;
    }

    public static File renameToRealType(File file) {
        String newSuffix = "." + FileUtil.getType((File)file);
        String canonicalPath = FileUtil.getCanonicalPath((File)file);
        if (canonicalPath.endsWith(newSuffix)) {
            return file;
        }
        String newPath = StringUtils.substringBeforeLast((String)canonicalPath, (String)".") + newSuffix;
        FileUtil.rename((File)file, (String)newPath, (boolean)false, (boolean)true);
        return new File(newPath);
    }

    public static List<File> loopDirs(String path) {
        return FileUtil.loopDirs(FileUtil.file((String)path));
    }

    public static List<File> loopDirs(File file) {
        return FileUtil.loopDirs(file, null);
    }

    public static List<File> loopDirs(String path, FileFilter fileFilter) {
        return FileUtil.loopDirs(FileUtil.file((String)path), fileFilter);
    }

    public static List<File> loopDirs(File file, FileFilter fileFilter) {
        return FileUtil.loopDirs(file, fileFilter, 0);
    }

    private static List<File> loopDirs(File file, FileFilter fileFilter, int deep) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (null == file || !file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            Object[] subFiles;
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            if (ArrayUtil.isNotEmpty((Object[])(subFiles = file.listFiles()))) {
                for (Object tmp : subFiles) {
                    fileList.addAll(FileUtil.loopDirs((File)tmp, fileFilter, ++deep));
                }
            }
        }
        return fileList;
    }

    public static List<File> loopDirsAndFiles(String path) {
        return FileUtil.loopDirsAndFiles(FileUtil.file((String)path));
    }

    public static List<File> loopDirsAndFiles(File file) {
        return FileUtil.loopDirsAndFiles(file, null);
    }

    public static List<File> loopDirsAndFiles(String path, FileFilter fileFilter) {
        return FileUtil.loopDirsAndFiles(FileUtil.file((String)path), fileFilter);
    }

    public static List<File> loopDirsAndFiles(File file, FileFilter fileFilter) {
        return FileUtil.loopDirsAndFiles(file, fileFilter, 0);
    }

    private static List<File> loopDirsAndFiles(File file, FileFilter fileFilter, int deep) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (null == file || !file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            Object[] subFiles;
            boolean add;
            boolean bl = add = deep > 0 && (null == fileFilter || fileFilter.accept(file));
            if (add) {
                fileList.add(file);
            }
            if (ArrayUtil.isNotEmpty((Object[])(subFiles = file.listFiles()))) {
                for (Object tmp : subFiles) {
                    fileList.addAll(FileUtil.loopDirsAndFiles((File)tmp, fileFilter, ++deep));
                }
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopDirsByPattern(String rootPath, String pathPattern) {
        return FileUtil.loopDirsByPattern(FileUtil.file((String)rootPath), pathPattern);
    }

    public static List<File> loopDirsByPattern(String rootPath, List<String> pathPatterns) {
        return FileUtil.loopDirsByPattern(FileUtil.file((String)rootPath), pathPatterns);
    }

    public static List<File> loopDirsByPattern(File file, String pathPattern) {
        if (pathPattern.contains(SPECIAL_S7)) {
            return FileUtil.loopDirsByPattern(file, Arrays.asList(pathPattern.split(SPECIAL_S8)));
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(FileUtil.dressPathPattern(pathPattern));
        List<File> files = FileUtil.loopDirs(file, (File pathname) -> matcher.matches(Paths.get(pathname.toURI())));
        return files;
    }

    public static List<File> loopDirsByPattern(File file, List<String> pathPatterns) {
        List matchers = pathPatterns.stream().map(FileUtil::dressPathPattern).map(p -> FileSystems.getDefault().getPathMatcher((String)p)).collect(Collectors.toList());
        List<File> files = FileUtil.loopDirs(file, (File pathname) -> {
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(Paths.get(pathname.toURI()))) continue;
                return true;
            }
            return false;
        });
        return files;
    }

    public static List<File> loopFilesByPattern(String rootPath, String pathPattern) {
        return FileUtil.loopFilesByPattern(FileUtil.file((String)rootPath), pathPattern);
    }

    public static List<File> loopFilesByPattern(String rootPath, List<String> pathPatterns) {
        return FileUtil.loopFilesByPattern(FileUtil.file((String)rootPath), pathPatterns);
    }

    public static List<File> loopFilesByPattern(File file, String pathPattern) {
        if (pathPattern.contains(SPECIAL_S7)) {
            return FileUtil.loopFilesByPattern(file, Arrays.asList(pathPattern.split(SPECIAL_S8)));
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(FileUtil.dressPathPattern(pathPattern));
        List files = FileUtil.loopFiles((File)file, pathname -> matcher.matches(Paths.get(pathname.toURI())));
        return files;
    }

    public static List<File> loopFilesByPattern(File file, List<String> pathPatterns) {
        List matchers = pathPatterns.stream().map(FileUtil::dressPathPattern).map(p -> FileSystems.getDefault().getPathMatcher((String)p)).collect(Collectors.toList());
        List files = FileUtil.loopFiles((File)file, pathname -> {
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(Paths.get(pathname.toURI()))) continue;
                return true;
            }
            return false;
        });
        return files;
    }

    public static List<File> loopDirsAndFilesByPattern(String rootPath, String pathPattern) {
        return FileUtil.loopDirsAndFilesByPattern(FileUtil.file((String)rootPath), pathPattern);
    }

    public static List<File> loopDirsAndFilesByPattern(String rootPath, List<String> pathPatterns) {
        return FileUtil.loopDirsAndFilesByPattern(FileUtil.file((String)rootPath), pathPatterns);
    }

    public static List<File> loopDirsAndFilesByPattern(File file, String pathPattern) {
        if (pathPattern.contains(SPECIAL_S7)) {
            return FileUtil.loopDirsAndFilesByPattern(file, Arrays.asList(pathPattern.split(SPECIAL_S8)));
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(FileUtil.dressPathPattern(pathPattern));
        List<File> files = FileUtil.loopDirsAndFiles(file, (File pathname) -> {
            System.out.println(pathname.getAbsolutePath());
            return matcher.matches(Paths.get(pathname.toURI()));
        });
        return files;
    }

    public static List<File> loopDirsAndFilesByPattern(File file, List<String> pathPatterns) {
        List matchers = pathPatterns.stream().map(FileUtil::dressPathPattern).map(p -> FileSystems.getDefault().getPathMatcher((String)p)).collect(Collectors.toList());
        List<File> files = FileUtil.loopDirsAndFiles(file, (File pathname) -> {
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(Paths.get(pathname.toURI()))) continue;
                return true;
            }
            return false;
        });
        return files;
    }

    public static String dressPathPattern(String pathPattern) {
        if (!pathPattern.startsWith(SPECIAL_S9) && !pathPattern.startsWith(SPECIAL_S10)) {
            pathPattern = SPECIAL_S9 + pathPattern;
        }
        return pathPattern;
    }

    public static String readAll(File file) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader utf8Reader = FileUtil.getUtf8Reader((File)file);){
            String tmp;
            while ((tmp = utf8Reader.readLine()) != null) {
                sb.append(tmp).append("\n");
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return sb.toString();
    }

    public static void writeAll(String content, File file) {
        if (!FileUtil.exist((File)file)) {
            FileUtil.touch((File)file);
        }
        try (BufferedWriter writer = FileUtil.getWriter((File)file, (Charset)StandardCharsets.UTF_8, (boolean)false);){
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static boolean hasDir(File dir) {
        if (dir == null || dir.isFile() || FileUtil.isDirEmpty((File)dir)) {
            return false;
        }
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir.toPath(), entry -> entry.toFile().isDirectory());
            return directoryStream.iterator().hasNext();
        }
        catch (IOException e) {
            return (Boolean)LambdaUtil.doThrow(e);
        }
    }

    public static boolean hasFile(File dir) {
        if (dir == null || dir.isFile() || FileUtil.isDirEmpty((File)dir)) {
            return false;
        }
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir.toPath(), entry -> entry.toFile().isFile());
            return directoryStream.iterator().hasNext();
        }
        catch (IOException e) {
            return (Boolean)LambdaUtil.doThrow(e);
        }
    }

    public static List<File> lsDirs(File dir) {
        return FileUtil.lsDirs(dir, f -> true);
    }

    public static List<File> lsDirs(File dir, FileFilter fileFilter) {
        return FileUtil.lsAll(dir, f -> f.isDirectory() && fileFilter.accept(f));
    }

    public static List<File> lsFiles(File dir) {
        return FileUtil.lsFiles(dir, f -> true);
    }

    public static List<File> lsFiles(File dir, FileFilter fileFilter) {
        return FileUtil.lsAll(dir, f -> f.isFile() && fileFilter.accept(f));
    }

    public static List<File> lsAll(File dir, FileFilter fileFilter) {
        if (dir == null || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        Object[] files = dir.listFiles();
        if (ArrayUtil.isEmpty((Object[])files)) {
            return Collections.emptyList();
        }
        List<File> dirs = Arrays.stream(files).filter(fileFilter::accept).collect(Collectors.toList());
        return dirs;
    }

    public static List<File> lsAll(File dir) {
        return FileUtil.lsAll(dir, f -> true);
    }

    public static String relaPath(File parent, File child) {
        String parentAbsolutePath = parent.getAbsolutePath();
        return child.getAbsolutePath().substring(parentAbsolutePath.length());
    }

    public static void sync(File source, File target) {
        if (source.isDirectory() && target.isDirectory()) {
            HashSet sourceFiles = Sets.newHashSet((Object[])source.list());
            HashSet targetFiles = Sets.newHashSet((Object[])target.list());
            for (String targetFile : targetFiles) {
                if (sourceFiles.contains(targetFile)) continue;
                FileUtil.del((File)new File(target, targetFile));
            }
            for (String sourceFile : sourceFiles) {
                File file = new File(source, sourceFile);
                File file2 = new File(target, sourceFile);
                if (file.isFile()) {
                    FileUtil.copyIfChanged(file, file2);
                    continue;
                }
                file2.mkdir();
                FileUtil.sync(file, file2);
            }
        } else if (source.isFile() && target.isFile()) {
            FileUtil.copyIfChanged(source, target);
        }
    }

    private static void copyIfChanged(File source, File target) {
        if (target.exists()) {
            if (source.length() == target.length() && FileUtil.checksumCRC32((File)source) == FileUtil.checksumCRC32((File)target)) {
                return;
            }
            target.delete();
        }
        if (!source.renameTo(target)) {
            FileUtil.move((File)source, (File)target, (boolean)true);
        }
    }
}

