/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.StrUtil;
import com.jeecms.exception.GlobalException;
import com.jeecms.exception.error.CoreErrs;
import com.jeecms.utils.CollectionUtil;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FileNameUtil
extends cn.hutool.core.io.file.FileNameUtil {
    static final String SPECIALS1 = "\u0000";
    public static final Set<String> IMG_EXT = CollectionUtil.newHashSet((Object[])new String[]{"jpg", "jpeg", "png", "gif", "bmp", "ico"});
    public static final Set<String> DOC_EXT = CollectionUtil.newHashSet((Object[])new String[]{"doc", "docx", "wps", "txt", "pdf"});
    public static final Set<String> EXCEL_EXT = CollectionUtil.newHashSet((Object[])new String[]{"xlsx", "xlsm", "xltx", "xltm", "xlsb", "xlam"});
    public static final Set<String> PPT_EXT = CollectionUtil.newHashSet((Object[])new String[]{"ppt", "pptx", "pptm", "ppsx", "potx", "potm"});
    public static final Set<String> VIDEO_EXT = CollectionUtil.newHashSet((Object[])new String[]{"avi", "asf", "wmv", "avs", "flv", "mkv", "mov", "3gp", "mp4", "mpg", "mpeg", "dat", "ogm", "vob", "rmvb", "rm", "ts", "ifo"});
    public static final Set<String> AUDIO_EXT = CollectionUtil.newHashSet((Object[])new String[]{"wav", "aac", "mp3", "aif", "au", "ram", "wma", "amr"});
    public static final Set<String> COMPRESS_EXT = CollectionUtil.newHashSet((Object[])new String[]{"zip", "rar", "tar", "gz", "tar.gz", "7z", "gzip"});

    public static String replaceSuffix(String originFileName, String suffix) {
        if (StrUtil.containsAny((CharSequence)suffix, (char[])new char[]{'/', '\\'})) {
            throw new UtilException("\u6269\u5c55\u540d\u4e2d\u4e0d\u80fd\u5305\u542b\u8def\u5f84\u76f8\u5173\u7684\u7b26\u53f7: /\u3001\\");
        }
        int dotIdx = originFileName.lastIndexOf(".");
        return dotIdx < 1 ? originFileName + "." + suffix : originFileName.substring(0, dotIdx + 1) + suffix;
    }

    public static boolean isDoc(String ext) {
        return DOC_EXT.contains(ext.toLowerCase());
    }

    public static boolean isImg(String ext) {
        return IMG_EXT.contains(ext.toLowerCase());
    }

    public static boolean isExcel(String ext) {
        return EXCEL_EXT.contains(ext.toLowerCase());
    }

    public static boolean isPpt(String ext) {
        return PPT_EXT.contains(ext.toLowerCase());
    }

    public static boolean isVideo(String ext) {
        return VIDEO_EXT.contains(ext.toLowerCase());
    }

    public static boolean isAudio(String ext) {
        return AUDIO_EXT.contains(ext.toLowerCase());
    }

    public static boolean isCompress(String ext) {
        return COMPRESS_EXT.contains(ext.toLowerCase());
    }

    public static void isValidFilename(String basePath, String filename) throws GlobalException {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new GlobalException(CoreErrs.ILLEGAL_PARAM);
        }
        String filenameType1 = "../";
        String filenameType2 = "..\\";
        if (filename.contains(filenameType1) || filename.contains(filenameType2) || filename.indexOf(SPECIALS1) != -1) {
            throw new GlobalException(CoreErrs.ILLEGAL_PARAM);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{basePath}) && !filename.startsWith(basePath)) {
            throw new GlobalException(CoreErrs.ILLEGAL_PARAM);
        }
    }
}

