/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesUtil {
    private static final String ALGORITHM = "DESede";
    private static final String TRANSFORMATION = "DESede/CBC/PKCS5Padding";
    private static final String ENCODING = "utf-8";
    private static final Logger logger = LoggerFactory.getLogger(DesUtil.class);

    public static String encrypt(String src, String key, String ivVal) {
        try {
            DESedeKeySpec dks = new DESedeKeySpec(key.getBytes(ENCODING));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            AlgorithmParameters iv = DesUtil.generateIv(ivVal);
            cipher.init(1, (Key)securekey, iv);
            byte[] b = cipher.doFinal(src.getBytes());
            return Base64.encodeBase64URLSafeString((byte[])b);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    private static AlgorithmParameters generateIv(String ivVal) throws Exception {
        byte[] iv = ivVal.getBytes();
        AlgorithmParameters params = AlgorithmParameters.getInstance(ALGORITHM);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static String decrypt(String encryptText, String key, String iv) {
        try {
            SecretKey deskey = null;
            DESedeKeySpec spec = new DESedeKeySpec(key.getBytes());
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance(ALGORITHM);
            deskey = keyfactory.generateSecret(spec);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec ips = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)deskey, ips);
            byte[] decryptData = cipher.doFinal(Base64.decodeBase64((String)encryptText));
            return new String(decryptData, ENCODING);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

