/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.date.DateUnit;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtil
extends cn.hutool.core.date.DateUtil {
    public static final String COMMON_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String COMMON_DATE_PATTERN = "yyyy-MM-dd";
    public static final String COMMON_DATE_MONTH_DAY_PATTERN = "MM-dd";
    public static final String COMMON_DATETIME_HOUR_PATTERN = "yyyy-MM-dd-HH";
    public static final String COMMON_TIME_PATTERN = "HH:mm:ss";
    public static final String COMMON_HOUR_MINUTE_PATTERN = "HH:mm";
    private static final Map<String, DateTimeFormatter> DATETIME_FORMATTER_MAP = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static Pattern DURATION_FORMAT_PATTERN;

    public static String format(LocalDateTime dateTime, String format) {
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        return dateTime.format(formatter);
    }

    public static String format(LocalDateTime dateTime) {
        return DateUtil.formatDateTime(dateTime);
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        return DateUtil.format(dateTime, COMMON_DATE_TIME_PATTERN);
    }

    public static String formatDate(LocalDateTime dateTime) {
        return DateUtil.format(dateTime, COMMON_DATE_PATTERN);
    }

    public static String formatDate(LocalDate date) {
        return DateUtil.format(date, COMMON_DATE_PATTERN);
    }

    public static String formatTime(LocalDateTime dateTime) {
        return DateUtil.format(dateTime, COMMON_TIME_PATTERN);
    }

    public static String formatTime(LocalTime time) {
        return DateUtil.format(time, COMMON_TIME_PATTERN);
    }

    public static String format(LocalDate date, String format) {
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        return date.format(formatter);
    }

    public static String format(LocalDate date) {
        return DateUtil.format(date, COMMON_DATE_PATTERN);
    }

    public static String format(LocalTime time, String format) {
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        return time.format(formatter);
    }

    public static String format(LocalTime time) {
        return DateUtil.format(time, COMMON_TIME_PATTERN);
    }

    public static String format(Date date) {
        return DateUtil.format((Date)date, (String)COMMON_DATE_TIME_PATTERN);
    }

    public static String formatNow(String format) {
        return DateUtil.format(LocalDateTime.now(), format);
    }

    public static String formatNow() {
        return DateUtil.format(LocalDateTime.now(), COMMON_DATE_TIME_PATTERN);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence charSequence, String format) {
        String dateStr = charSequence.toString();
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        LocalDateTime ldt = LocalDateTime.parse(dateStr, formatter);
        return ldt;
    }

    public static LocalDateTime parseLocalDateTime(CharSequence charSequence) {
        return DateUtil.parseLocalDateTime(charSequence, COMMON_DATE_TIME_PATTERN);
    }

    public static LocalDate parseLocalDate(CharSequence charSequence, String format) {
        String dateStr = charSequence.toString();
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        LocalDate ld = LocalDate.parse(dateStr, formatter);
        return ld;
    }

    public static LocalDate parseLocalDate(CharSequence charSequence) {
        return DateUtil.parseLocalDate(charSequence, COMMON_DATE_PATTERN);
    }

    public static LocalTime parseLocalTime(CharSequence charSequence, String format) {
        String timeStr = charSequence.toString();
        DateTimeFormatter formatter = DateUtil.getFormatter(format);
        LocalTime lt = LocalTime.parse(timeStr, formatter);
        return lt;
    }

    public static LocalTime parseLocalTime(CharSequence charSequence) {
        return DateUtil.parseLocalTime(charSequence, COMMON_TIME_PATTERN);
    }

    public static long toMilli(LocalDateTime localDateTime) {
        return localDateTime.toInstant(DateUtil.zone()).toEpochMilli();
    }

    public static long between(LocalDateTime beginDate, LocalDateTime endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(LocalDateTime beginDate, LocalDateTime endDate, DateUnit unit, boolean isAbs) {
        long beginMilli = DateUtil.toMilli(beginDate);
        long endMilli = DateUtil.toMilli(endDate);
        long diffMilli = endMilli - beginMilli;
        long r = diffMilli / unit.getMillis();
        return isAbs ? Math.abs(r) : r;
    }

    public static LocalDateTime localDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), DateUtil.zone());
    }

    public static LocalDateTime localDateTime(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), DateUtil.zone());
        return localDateTime;
    }

    public static boolean isIn(LocalTime time, LocalTime startTime, LocalTime endTime) {
        long start = startTime.toNanoOfDay();
        long end = endTime.toNanoOfDay();
        long specify = time.toNanoOfDay();
        return specify >= start && specify <= end;
    }

    public static boolean isIn(LocalDate date, LocalDate startDate, LocalDate endDate) {
        long start = startDate.toEpochDay();
        long end = endDate.toEpochDay();
        long specify = date.toEpochDay();
        return specify >= start && specify <= end;
    }

    public static boolean isIn(LocalDateTime dateTime, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        long start = DateUtil.toMilli(startDateTime);
        long end = DateUtil.toMilli(endDateTime);
        long specify = DateUtil.toMilli(dateTime);
        return specify >= start && specify <= end;
    }

    private static ZoneOffset zone() {
        return ZoneOffset.of("+8");
    }

    private static DateTimeFormatter getFormatter(String format) {
        return DATETIME_FORMATTER_MAP.computeIfAbsent(format, DateTimeFormatter::ofPattern);
    }

    public static String formatDuration(long milli) {
        return DateUtil.formatDuration(milli, COMMON_TIME_PATTERN);
    }

    public static String formatDuration(long milli, String format) {
        Matcher matcher = DURATION_FORMAT_PATTERN.matcher(format);
        if (matcher.find()) {
            String hFormat = matcher.group(1);
            String sp1 = matcher.group(2);
            String mFormat = matcher.group(3);
            String sp2 = matcher.group(4);
            String sFormat = matcher.group(5);
            if (StringUtils.isNotBlank((CharSequence)mFormat) && StringUtils.isNotBlank((CharSequence)sFormat)) {
                String sPlaceholder;
                String string = sPlaceholder = sFormat.length() == 1 ? "%d" : "%02d";
                if (StringUtils.isBlank((CharSequence)hFormat)) {
                    long m = milli / 1000L / 60L;
                    long s = (milli - m * 1000L * 60L) / 1000L;
                    String mStr = String.valueOf(m);
                    if (mStr.length() < mFormat.length()) {
                        char[] pend = new char[mFormat.length() - mStr.length()];
                        Arrays.fill(pend, '0');
                        mStr = String.copyValueOf(pend) + mStr;
                    }
                    return matcher.replaceAll(String.format("%s" + sp2 + sPlaceholder, mStr, s));
                }
                long h = milli / 1000L / 60L / 60L;
                long m = (milli - h * 1000L * 60L * 60L) / 1000L / 60L;
                long s = (milli - h * 1000L * 60L * 60L - m * 1000L * 60L) / 1000L;
                String hStr = String.valueOf(h);
                if (hStr.length() < hFormat.length()) {
                    char[] pend = new char[hFormat.length() - hStr.length()];
                    Arrays.fill(pend, '0');
                    hStr = String.copyValueOf(pend) + hStr;
                }
                String mPlaceholder = mFormat.length() == 1 ? "%d" : "%02d";
                return matcher.replaceAll(String.format("%s" + sp1 + mPlaceholder + sp2 + sPlaceholder, hStr, m, s));
            }
        }
        throw new IllegalArgumentException("\u683c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u6b63\u786e");
    }

    public static String formatDuration(long duration, TimeUnit timeUnit, String format) {
        return DateUtil.formatDuration(timeUnit.toMillis(duration), format);
    }

    public static LocalDateTime beginOfDay() {
        return DateUtil.beginOfDay(LocalDateTime.now());
    }

    public static LocalDateTime endOfDay() {
        return DateUtil.endOfDay(LocalDateTime.now());
    }

    public static LocalDateTime beginOfDay(LocalDateTime dateTime) {
        return LocalDateTime.of(dateTime.toLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime beginOfDay(LocalDate date) {
        return LocalDateTime.of(date, LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime dateTime) {
        LocalDateTime localDateTime = DateUtil.endOfDay(dateTime.toLocalDate());
        LocalDateTime newLdt = LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        return newLdt;
    }

    public static LocalDateTime endOfDay(LocalDate time) {
        return LocalDateTime.of(time, LocalTime.MAX);
    }

    public static LocalDateTime beginOfMonth() {
        return DateUtil.beginOfMonth(LocalDateTime.now());
    }

    public static LocalDateTime beginOfMonth(LocalDateTime dateTime) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.beginOfMonthLocalDate(dateTime.toLocalDate()), LocalTime.MIN);
        return firstDay;
    }

    public static LocalDate beginOfMonthLocalDate() {
        return DateUtil.beginOfMonthLocalDate(LocalDate.now());
    }

    public static LocalDate beginOfMonthLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(TemporalAdjusters.firstDayOfMonth());
        return firstDay;
    }

    public static LocalDateTime endOfMonth() {
        return DateUtil.endOfMonth(LocalDateTime.now());
    }

    public static LocalDate endOfMonthLocalDate() {
        return DateUtil.endOfMonthLocalDate(LocalDate.now());
    }

    public static LocalDateTime endOfMonth(LocalDateTime dateTime) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.endOfMonthLocalDate(dateTime.toLocalDate()), LocalTime.MAX);
        return firstDay;
    }

    public static LocalDate endOfMonthLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(TemporalAdjusters.lastDayOfMonth());
        return firstDay;
    }

    public static LocalDateTime beginOfYear() {
        return DateUtil.beginOfYear(LocalDateTime.now());
    }

    public static LocalDate beginOfYearLocalDate() {
        return DateUtil.beginOfYearLocalDate(LocalDate.now());
    }

    public static LocalDateTime beginOfYear(LocalDateTime dateTime) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.beginOfYearLocalDate(dateTime.toLocalDate()), LocalTime.MIN);
        return firstDay;
    }

    public static LocalDate beginOfYearLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(TemporalAdjusters.firstDayOfYear());
        return firstDay;
    }

    public static LocalDateTime endOfYear() {
        return DateUtil.endOfYear(LocalDateTime.now());
    }

    public static LocalDate endOfYearLocalDate() {
        return DateUtil.endOfYearLocalDate(LocalDate.now());
    }

    public static LocalDateTime endOfYear(LocalDateTime dateTime) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.endOfYearLocalDate(dateTime.toLocalDate()), LocalTime.MAX);
        return firstDay;
    }

    public static LocalDate endOfYearLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(TemporalAdjusters.lastDayOfYear());
        return firstDay;
    }

    public static LocalDateTime beginOfWeek() {
        return DateUtil.beginOfWeek(LocalDateTime.now());
    }

    public static LocalDateTime beginOfWeek(LocalDateTime date) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.beginOfWeekLocalDate(date.toLocalDate()), LocalTime.MIN);
        return firstDay;
    }

    public static LocalDate beginOfWeekLocalDate() {
        return DateUtil.beginOfWeekLocalDate(LocalDate.now());
    }

    public static LocalDate beginOfWeekLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(DayOfWeek.MONDAY);
        return firstDay;
    }

    public static LocalDate endOfWeekLocalDate() {
        return DateUtil.beginOfWeekLocalDate(LocalDate.now());
    }

    public static LocalDate endOfWeekLocalDate(LocalDate date) {
        LocalDate firstDay = date.with(DayOfWeek.SUNDAY);
        return firstDay;
    }

    public static LocalDateTime endOfWeek() {
        return DateUtil.endOfWeek(LocalDateTime.now());
    }

    public static LocalDateTime endOfWeek(LocalDateTime date) {
        LocalDateTime firstDay = LocalDateTime.of(DateUtil.endOfWeekLocalDate(date.toLocalDate()), LocalTime.MAX);
        return firstDay;
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate dateToLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime max(LocalDateTime ... dateTimes) {
        if (dateTimes == null) {
            return null;
        }
        if (dateTimes.length == 1) {
            return dateTimes[0];
        }
        return Arrays.stream(dateTimes).max(LocalDateTime::compareTo).get();
    }

    public static LocalDateTime min(LocalDateTime ... dateTimes) {
        if (dateTimes == null) {
            return null;
        }
        if (dateTimes.length == 1) {
            return dateTimes[0];
        }
        return Arrays.stream(dateTimes).min(LocalDateTime::compareTo).get();
    }

    public static String fromatStr(LocalDateTime date) {
        int nowYear;
        String format = null;
        LocalDateTime now = LocalDateTime.now();
        int dateYear = date.getYear();
        if (dateYear != (nowYear = now.getYear())) {
            format = DateUtil.format(date, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        } else {
            long dayBetween = DateUtil.between(date.toLocalDate().atTime(0, 0), now.toLocalDate().atTime(0, 0), DateUnit.DAY);
            if (dayBetween == 1L) {
                format = DateUtil.format(date, "\u6628\u5929 HH:mm");
            } else if (dayBetween >= 2L) {
                format = DateUtil.format(date, "MM\u6708dd\u65e5 HH:mm");
            } else if (dayBetween == 0L) {
                long hourBetween = DateUtil.between(date, now, DateUnit.HOUR);
                if (hourBetween >= 1L) {
                    format = hourBetween + "\u5c0f\u65f6\u524d";
                } else if (hourBetween == 0L) {
                    long minBetween = DateUtil.between(date, now, DateUnit.MINUTE);
                    if (minBetween == 0L) {
                        long secondBetween = DateUtil.between(date, now, DateUnit.SECOND);
                        format = secondBetween + "\u79d2\u524d";
                    } else {
                        format = minBetween + "\u5206\u949f\u524d";
                    }
                }
            }
        }
        return format;
    }

    public static boolean isToDay(LocalDateTime localDateTime) {
        LocalDateTime nowDay;
        LocalDateTime day = DateUtil.beginOfDay(localDateTime);
        return Objects.equals(day, nowDay = DateUtil.beginOfDay(LocalDateTime.now()));
    }

    public static void main(String[] args) {
        LocalDateTime localDateTime = LocalDateTime.of(2021, 7, 8, 11, 51);
        System.out.println(DateUtil.isToDay(localDateTime));
    }

    static {
        DATETIME_FORMATTER_MAP.put(COMMON_DATE_TIME_PATTERN, DateTimeFormatter.ofPattern(COMMON_DATE_TIME_PATTERN));
        DATETIME_FORMATTER_MAP.put(COMMON_DATE_PATTERN, DateTimeFormatter.ofPattern(COMMON_DATE_PATTERN));
        DATETIME_FORMATTER_MAP.put(COMMON_TIME_PATTERN, DateTimeFormatter.ofPattern(COMMON_TIME_PATTERN));
        DURATION_FORMAT_PATTERN = Pattern.compile("(H*)([^H]*?)(m+)([^m]*?)(s{1,2})");
    }
}

