/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataMaskUtil {
    private static final int PHONE_LENGTH = 11;
    private static final Pattern TEL_PATTERN = Pattern.compile("\\(?\\d{2,4}[)\\-_](\\d{7,8})");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([A-Za-z0-9\\u4e00-\\u9fa5]+)(@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+)$");
    private static final List<String> DOUBLE_SURNAMES = Collections.unmodifiableList(Arrays.asList("\u6b27\u9633", "\u592a\u53f2", "\u7aef\u6728", "\u4e0a\u5b98", "\u53f8\u9a6c", "\u4e1c\u65b9", "\u72ec\u5b64", "\u5357\u5bab", "\u4e07\u4fdf", "\u95fb\u4eba", "\u590f\u4faf", "\u8bf8\u845b", "\u5c09\u8fdf", "\u516c\u7f8a", "\u8d6b\u8fde", "\u6fb9\u53f0", "\u7687\u752b", "\u5b97\u653f", "\u6fee\u9633", "\u516c\u51b6", "\u592a\u53d4", "\u7533\u5c60", "\u516c\u5b59", "\u6155\u5bb9", "\u4ef2\u5b59", "\u949f\u79bb", "\u957f\u5b59", "\u5b87\u6587", "\u53f8\u5f92", "\u9c9c\u4e8e", "\u53f8\u7a7a", "\u95fe\u4e18", "\u5b50\u8f66", "\u4e93\u5b98", "\u53f8\u5bc7", "\u5deb\u9a6c", "\u516c\u897f", "\u989b\u5b59", "\u58e4\u9a77", "\u516c\u826f", "\u6f06\u96d5", "\u4e50\u6b63", "\u5bb0\u7236", "\u8c37\u6881", "\u62d3\u8dcb", "\u5939\u8c37", "\u8f69\u8f95", "\u4ee4\u72d0", "\u6bb5\u5e72", "\u767e\u91cc", "\u547c\u5ef6", "\u4e1c\u90ed", "\u5357\u95e8", "\u7f8a\u820c", "\u5fae\u751f", "\u516c\u6237", "\u516c\u7389", "\u516c\u4eea", "\u6881\u4e18", "\u516c\u4ef2", "\u516c\u4e0a", "\u516c\u95e8", "\u516c\u5c71", "\u516c\u575a", "\u5de6\u4e18", "\u516c\u4f2f", "\u897f\u95e8", "\u516c\u7956", "\u7b2c\u4e94", "\u516c\u4e58", "\u8d2f\u4e18", "\u516c\u7699", "\u5357\u8363", "\u4e1c\u91cc", "\u4e1c\u5bab", "\u4ef2\u957f", "\u5b50\u4e66", "\u5b50\u6851", "\u5373\u58a8", "\u8fbe\u595a", "\u891a\u5e08"));

    public static String dePhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return phone;
        }
        if (phone.length() != 11) {
            return phone;
        }
        char[] chars = phone.toCharArray();
        chars[6] = 42;
        chars[5] = 42;
        chars[4] = 42;
        chars[3] = 42;
        return String.valueOf(chars);
    }

    public static String deTel(String tel) {
        if (StringUtils.isBlank((CharSequence)tel)) {
            return tel;
        }
        Matcher matcher = TEL_PATTERN.matcher(tel);
        if (matcher.find()) {
            String num = matcher.group(1);
            char[] chars = num.toCharArray();
            if (chars.length == 7) {
                char[] newChars = new char[8];
                System.arraycopy(chars, 0, newChars, 0, 2);
                System.arraycopy(chars, 4, newChars, 5, 3);
                chars = newChars;
            }
            chars[4] = 42;
            chars[3] = 42;
            chars[2] = 42;
            return matcher.group().replaceFirst(num, String.valueOf(chars));
        }
        return tel;
    }

    public static String deEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return email;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        if (matcher.find()) {
            String g1 = matcher.group(1);
            String g2 = matcher.group(2);
            String dg1 = g1.substring(0, Math.min(g1.length(), 2));
            return dg1 + "**" + g2;
        }
        return email;
    }

    public static String deName(String fullName) {
        if (fullName == null || fullName.length() < 2) {
            return fullName;
        }
        if (fullName.length() == 2) {
            return fullName.charAt(0) + "*";
        }
        String surname = null;
        for (String doubleSurname : DOUBLE_SURNAMES) {
            if (!fullName.startsWith(doubleSurname)) continue;
            surname = StringUtils.left((String)fullName, (int)2);
            break;
        }
        if (surname == null) {
            surname = StringUtils.left((String)fullName, (int)1);
        }
        if (fullName.length() - surname.length() > 1) {
            return surname + "**";
        }
        return surname + "*";
    }

    public static String deIdNumber(String idNumber) {
        if (idNumber == null || idNumber.length() != 15 && idNumber.length() != 18) {
            return idNumber;
        }
        if (idNumber.length() == 15) {
            idNumber = idNumber.replaceAll("(\\w{6})\\w*(\\w{3})", "$1******$2");
        }
        if (idNumber.length() == 18) {
            idNumber = idNumber.replaceAll("(\\w{6})\\w*(\\w{3})", "$1*********$2");
        }
        return idNumber;
    }

    public static String deAddress(String address) {
        if (address == null || address.length() < 4) {
            return address;
        }
        if (address.length() < 12) {
            return StringUtils.rightPad((String)StringUtils.left((String)address, (int)3), (int)address.length(), (String)"*");
        }
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)3), (int)11, (String)"*").concat(address.substring(11));
    }

    public static void main(String[] args) {
        String asdasdf = DataMaskUtil.deAddress("123456");
        System.out.println(asdasdf);
    }
}

