/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class CronUtil {
    public static String createCron(Date jobTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(jobTime);
        return CronUtil.createCron(calendar.get(13), calendar.get(12), calendar.get(11), calendar.get(5), calendar.get(2) + 1, "?", calendar.get(1));
    }

    public static String createCron(Date jobBeginTime, int interval, TimeUnit intervalUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(jobBeginTime);
        return CronUtil.createCron(calendar.get(13), intervalUnit == TimeUnit.MINUTE ? calendar.get(12) + "/" + interval : Integer.valueOf(calendar.get(12)), intervalUnit == TimeUnit.HOUR ? calendar.get(11) + "/" + interval : Integer.valueOf(calendar.get(11)), intervalUnit == TimeUnit.DAY ? calendar.get(5) + "/" + interval : Integer.valueOf(calendar.get(5)), calendar.get(2) + 1, "?", "");
    }

    public static String createCron(LocalDateTime jobTime) {
        return CronUtil.createCron(jobTime.getSecond(), jobTime.getMinute(), jobTime.getHour(), jobTime.getDayOfMonth(), jobTime.getMonth().getValue(), "?", jobTime.getYear());
    }

    public static String createCron(LocalDateTime jobBeginTime, int interval, TimeUnit intervalUnit) {
        return CronUtil.createCron(jobBeginTime.getSecond(), intervalUnit == TimeUnit.MINUTE ? jobBeginTime.getMinute() + "/" + interval : Integer.valueOf(jobBeginTime.getMinute()), intervalUnit == TimeUnit.HOUR ? jobBeginTime.getHour() + "/" + interval : Integer.valueOf(jobBeginTime.getHour()), intervalUnit == TimeUnit.DAY ? jobBeginTime.getDayOfMonth() + "/" + interval : Integer.valueOf(jobBeginTime.getDayOfMonth()), jobBeginTime.getMonth().getValue(), "?", "");
    }

    private static String createCron(Object second, Object minute, Object hour, Object day, Object month, Object week, Object year) {
        return String.format("%s %s %s %s %s %s %s", second, minute, hour, day, month, week, year);
    }

    public static enum TimeUnit {
        DAY,
        HOUR,
        MINUTE;

    }
}

