/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import java.awt.Color;

public class ColorUtil {
    public static Color parseColor(String str) {
        if (str.length() == 7) {
            return ColorUtil.hexToColor(str.substring(1));
        }
        if (str.length() == 6) {
            return ColorUtil.hexToColor(str);
        }
        if (str.length() == 4) {
            return ColorUtil.shortHexToColor(str.substring(1));
        }
        if (str.length() == 3) {
            return ColorUtil.shortHexToColor(str);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u989c\u8272\uff1a" + str);
    }

    public static Color hexToColor(String hexStr) {
        return new Color(Integer.parseInt(hexStr.substring(0, 2), 16), Integer.parseInt(hexStr.substring(2, 4), 16), Integer.parseInt(hexStr.substring(4, 6), 16));
    }

    public static Color shortHexToColor(String shortHexStr) {
        char c0 = shortHexStr.charAt(0);
        char c1 = shortHexStr.charAt(1);
        char c2 = shortHexStr.charAt(2);
        return ColorUtil.hexToColor("" + c0 + c0 + c1 + c1 + c2 + c2);
    }

    public static boolean isColor(String str) {
        try {
            ColorUtil.parseColor(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

