/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.RandomUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CollectionUtil
extends cn.hutool.core.collection.CollectionUtil {
    public static <T> boolean contains(Collection<T> collection, Function<T, Object> function, Object value) {
        return CollectionUtil.contains(collection, ele -> Objects.equals(function.apply(ele), value));
    }

    public static <T> T get(Collection<T> collection, Function<T, Object> function, Object value) {
        return (T)CollectionUtil.get(collection, ele -> Objects.equals(function.apply(ele), value));
    }

    public static <T> T get(Collection<T> collection, Predicate<T> predicate) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        for (T ele : collection) {
            if (ele == null || !predicate.test(ele)) continue;
            return ele;
        }
        return null;
    }

    public static <T> Integer getIndex(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || !predicate.test(list.get(i))) continue;
            return i;
        }
        return null;
    }

    public static <T> List<T> sub(Collection<T> collection, Function<T, Object> function, Object value) {
        return CollectionUtil.sub(collection, ele -> Objects.equals(function.apply(ele), value));
    }

    public static <T> List<T> sub(Collection<T> collection, Predicate<T> predicate) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        List collect = collection.stream().filter(predicate).collect(Collectors.toList());
        return collect;
    }

    public static <T> T computeIfAbsent(Collection<T> collection, Predicate<T> predicate, Supplier<T> supplier) {
        T ret = CollectionUtil.get(collection, predicate);
        if (ret == null) {
            ret = supplier.get();
            collection.add(ret);
        }
        return ret;
    }

    public static <T> T computeIfAbsent(Collection<T> collection, Function<T, Object> function, Object value, Supplier<T> supplier) {
        return (T)CollectionUtil.computeIfAbsent(collection, ele -> Objects.equals(function.apply(ele), value), supplier);
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        Object[][] arrays = new Object[lists.size()][];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = lists.get(i).toArray();
        }
        return CollectionUtil.cartesianProduct(arrays);
    }

    public static <T> List<List<T>> cartesianProduct(T[][] arrays) {
        int[][] indexAndLength = new int[2][arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            indexAndLength[0][i] = 0;
            indexAndLength[1][i] = arrays[i].length;
        }
        ArrayList<List<T>> cartesianProductList = new ArrayList<List<T>>();
        CollectionUtil.getOptions(arrays, indexAndLength, cartesianProductList);
        return cartesianProductList;
    }

    private static <T> void getOptions(T[][] arrays, int[][] indexAndLength, List<List<T>> cartesianProductList) {
        ArrayList<T> ret = new ArrayList<T>(arrays.length);
        cartesianProductList.add(ret);
        for (int i = 0; i < arrays.length; ++i) {
            ret.add(arrays[i][indexAndLength[0][i]]);
        }
        if (CollectionUtil.addIndex(indexAndLength, arrays.length)) {
            CollectionUtil.getOptions(arrays, indexAndLength, cartesianProductList);
        }
    }

    private static boolean addIndex(int[][] indexAndLength, int index) {
        if (index <= 0) {
            return false;
        }
        int[] nArray = indexAndLength[0];
        int n = index - 1;
        nArray[n] = nArray[n] + 1;
        if (nArray[n] < indexAndLength[1][index - 1]) {
            return true;
        }
        indexAndLength[0][index - 1] = 0;
        return CollectionUtil.addIndex(indexAndLength, index - 1);
    }

    public static boolean isAllNull(Collection<?> collection) {
        for (Object o : collection) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEmpty(Iterable<String> iter) {
        return CollectionUtil.hasEmpty(null == iter ? null : iter.iterator());
    }

    public static boolean hasEmpty(Iterator<String> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (!StringUtils.isBlank((CharSequence)iter.next())) continue;
            return true;
        }
        return false;
    }

    public static <E> Collection<E> removeAll(Collection<E> collection, Predicate<E> predicate) {
        List<E> sub = CollectionUtil.sub(collection, predicate);
        if (CollectionUtil.isNotEmpty(sub)) {
            collection.removeAll(sub);
        }
        return collection;
    }

    public static <E1, E2> List<E2> shadowSort(List<E1> sourceList, Function<E1, ?> function1, List<E2> targetList, Function<E2, ?> function2) {
        List collect = sourceList.stream().map(function1).collect(Collectors.toList());
        HashMap idxMap = new HashMap(collect.size());
        for (int i = 0; i < collect.size(); ++i) {
            idxMap.put(collect.get(i), i);
        }
        targetList.sort(Comparator.comparingInt(o -> Optional.ofNullable(idxMap.get(function2.apply(o))).orElse(Integer.MAX_VALUE)));
        return targetList;
    }

    public static <E, R> List<R> convert(Collection<E> coll, Function<E, R> converter) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return Collections.emptyList();
        }
        return coll.stream().map(converter).collect(Collectors.toList());
    }

    public static <E, R> Set<R> convertToSet(Collection<E> coll, Function<E, R> converter) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return Collections.emptySet();
        }
        return coll.stream().map(converter::apply).collect(Collectors.toSet());
    }

    public static <E, R> List<R> convert(Collection<E> coll, Function<E, R> converter, Consumer<R> consumer) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return Collections.emptyList();
        }
        List rList = coll.stream().map(ele -> {
            Object r = converter.apply(ele);
            consumer.accept(r);
            return r;
        }).collect(Collectors.toList());
        return rList;
    }

    public static <E> List<E> shuffle(List<E> list) {
        for (int i = 0; i < list.size(); ++i) {
            int ri = RandomUtil.randomInt((int)(i + 1));
            Collections.swap(list, i, ri);
        }
        return list;
    }

    public static <E> List<E> concat(Collection<E> ... colls) {
        List newList = Arrays.stream(colls).filter(Objects::nonNull).flatMap(coll -> coll.stream()).collect(Collectors.toList());
        return newList;
    }

    public static <E> List<E> merge(Collection<E> ... colls) {
        List newList = Arrays.stream(colls).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return newList;
    }

    public static <E> List<E> merge(Collection<? extends Collection<E>> colls) {
        List newList = colls.stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return newList;
    }

    public static <E> E sutIfAbsent(List<E> list, int idx, E ele) {
        int size = list.size();
        if (idx >= size) {
            Object[] arr = new Object[idx - size + 1];
            list.addAll(Arrays.asList(arr));
            list.set(idx, ele);
            return ele;
        }
        if (idx == size) {
            list.add(ele);
            return ele;
        }
        E obj = list.get(idx);
        if (obj == null) {
            list.set(idx, ele);
            return ele;
        }
        return obj;
    }

    public static <E> E computeIfAbsent(List<E> list, int idx, Function<Integer, E> func) {
        int size = list.size();
        if (idx > size) {
            Object[] arr = new Object[idx - size + 1];
            list.addAll(Arrays.asList(arr));
            E ele = func.apply(idx);
            list.set(idx, ele);
            return ele;
        }
        if (idx == size) {
            E ele = func.apply(idx);
            list.add(ele);
            return ele;
        }
        E obj = list.get(idx);
        if (obj == null) {
            E ele = func.apply(idx);
            list.set(idx, ele);
            return ele;
        }
        return obj;
    }

    public static <E> List<E> remain(Collection<E> coll1, Collection<E> coll2, Function<E, ?> function) {
        return CollectionUtil.remain(coll1, coll2, function, function);
    }

    public static <E1, E2> List<E1> remain(Collection<E1> coll1, Collection<E2> coll2, Function<E1, ?> function1, Function<E2, ?> function2) {
        Set<?> set = CollectionUtil.convertToSet(coll2, function2);
        set.remove(null);
        List list = coll1.stream().filter(e -> !set.contains(function1.apply(e))).collect(Collectors.toList());
        return list;
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> coll, Function<? super E, K> keyMapper, Function<? super E, V> valueMapper) {
        Map<K, V> map = coll.stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return map;
    }

    public static <E> List<E> toList(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        return IterUtil.toList(iterable);
    }

    public static <T> List<T> addFirst(List<T> list, T first) {
        if (list instanceof Deque) {
            Deque deque = (Deque)((Object)list);
            deque.addFirst(first);
        } else {
            list.add(0, first);
        }
        return list;
    }

    public static <T, K, V> Map<K, V> convertToMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Map<? extends K, ? extends V> map = list.stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return map;
    }
}

