/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class CglibUtil {
    private static final Logger log = LoggerFactory.getLogger(CglibUtil.class);

    public static <T> T proxy(T target, MethodInterceptor methodInterceptor) {
        if (target instanceof Class) {
            return CglibUtil.proxy((Class)target, methodInterceptor);
        }
        Object proxy = CglibUtil.proxy(target.getClass(), methodInterceptor);
        BeanUtil.copyProperties(target, proxy, (String[])new String[0]);
        return (T)proxy;
    }

    public static <T> T proxy(Class<T> clazz, MethodInterceptor methodInterceptor) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)methodInterceptor);
        Object proxy = enhancer.create();
        return (T)proxy;
    }

    public static Object dynamicField(Object dest, Map<String, ?> addProperties) {
        HashMap propertyMap = Maps.newHashMapWithExpectedSize((int)addProperties.size());
        for (String key : addProperties.keySet()) {
            propertyMap.put(key, addProperties.get(key).getClass());
        }
        DynamicBean dynamicBean = new DynamicBean(dest.getClass(), propertyMap);
        addProperties.forEach((k, v) -> dynamicBean.setValue((String)k, v));
        Object target = dynamicBean.getTarget();
        BeanUtil.copyProperties((Object)dest, (Object)target, (String[])new String[0]);
        return target;
    }

    private static class DynamicBean {
        private Object target;
        private BeanMap beanMap;

        DynamicBean(Class superclass, Map<String, Class> propertyMap) {
            this.target = this.generateBean(superclass, propertyMap);
            this.beanMap = BeanMap.create((Object)this.target);
        }

        void setValue(String property, Object value) {
            log.debug("beanMap.put => {}:{}", (Object)property, value);
            this.beanMap.put((Object)property, value);
        }

        Object getValue(String property) {
            return this.beanMap.get((Object)property);
        }

        Object getTarget() {
            return this.target;
        }

        private Object generateBean(Class superclass, Map<String, Class> propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            if (null != superclass) {
                generator.setSuperclass(superclass);
            }
            BeanGenerator.addProperties((BeanGenerator)generator, propertyMap);
            return generator.create();
        }
    }
}

