/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils;

import cn.hutool.core.util.RandomUtil;
import com.jeecms.exception.GlobalRuntimeException;
import com.jeecms.exception.error.CoreErrs;
import com.jeecms.util.RedisUtil;
import com.jeecms.utils.Assert;
import com.jeecms.utils.notify.NotifyEnum;
import com.jeecms.utils.notify.NotifyUtil;
import com.jeecms.utils.spring.SpringUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class CaptchaUtil {
    public static boolean match(String key, String code) {
        String captcha = CaptchaUtil.getCaptcha(key);
        if (StringUtils.isBlank((CharSequence)captcha)) {
            return false;
        }
        return captcha.equals(code);
    }

    public static void valid(String key, String code) {
        String captcha = CaptchaUtil.getCaptcha(key);
        if (StringUtils.isBlank((CharSequence)captcha)) {
            throw new GlobalRuntimeException(CoreErrs.CAPTCHA_NOT_EXIST_OR_EXPIRED);
        }
        if (!captcha.equals(code)) {
            throw new GlobalRuntimeException(CoreErrs.CAPTCHA_MISTAKEN);
        }
    }

    public static String getCaptcha(String key) {
        return (String)CaptchaUtil.getRedisUtil().get(key);
    }

    public static void sendSmsCaptcha(String phone, String key, String templateSymbol) {
        CaptchaUtil.sendSmsCaptcha(phone, key, templateSymbol, () -> {});
    }

    public static void sendSmsCaptcha(String phone, String key, String templateSymbol, Runnable validRunnable) {
        CaptchaUtil.doSendCaptcha(phone, key, templateSymbol, validRunnable, NotifyUtil::sendSmsNotify);
    }

    public static void sendEmailCaptcha(String email, String key, String templateSymbol) {
        CaptchaUtil.sendEmailCaptcha(email, key, templateSymbol, () -> {});
    }

    public static void sendEmailCaptcha(String email, String key, String templateSymbol, Runnable validRunnable) {
        CaptchaUtil.doSendCaptcha(email, key, templateSymbol, validRunnable, NotifyUtil::sendEmailNotify);
    }

    public static void sendCaptcha(NotifyEnum type, String target, String key, String templateSymbol) {
        CaptchaUtil.sendCaptcha(type, target, key, templateSymbol, () -> {});
    }

    public static void sendCaptcha(NotifyEnum type, String target, String key, String templateSymbol, Runnable validRunnable) {
        if (type == NotifyEnum.SMS) {
            CaptchaUtil.sendSmsCaptcha(target, key, templateSymbol, validRunnable);
        } else if (type == NotifyEnum.EMAIL) {
            CaptchaUtil.sendEmailCaptcha(target, key, templateSymbol, validRunnable);
        } else {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u53d1\u9001\u9a8c\u8bc1\u7801\uff1a" + (Object)((Object)type));
        }
    }

    private static void doSendCaptcha(String target, String key, String templateSymbol, Runnable validRunnable, Sender sender) {
        Assert.notBlank((CharSequence)target, (String)"\u9a8c\u8bc1\u7801\u63a5\u6536\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long keyAge = CaptchaUtil.getRedisUtil().getAge(key, TimeUnit.MINUTES);
        if (keyAge == 0L) {
            throw new GlobalRuntimeException(CoreErrs.CAPTCHA_TOO_FAST);
        }
        validRunnable.run();
        String captcha = RandomUtil.randomString((String)"0123456789", (int)6);
        Map<String, String> map = Collections.singletonMap("code", captcha);
        sender.send(templateSymbol, map, target);
        CaptchaUtil.getRedisUtil().setAndRecordTime(key, captcha, Duration.ofMinutes(5L));
    }

    private static RedisUtil getRedisUtil() {
        return SpringUtil.getBean(RedisUtil.class);
    }

    @FunctionalInterface
    private static interface Sender {
        public void send(String var1, Map<String, String> var2, String var3);
    }
}

