/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.serialization;

import com.jeecms.utils.DataMaskUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Mask {
    public Type value();

    public static enum Type {
        LANDLINE{

            @Override
            String mask(String val) {
                return DataMaskUtil.deTel(val);
            }
        }
        ,
        MOBILE{

            @Override
            String mask(String val) {
                return DataMaskUtil.dePhone(val);
            }
        }
        ,
        EMAIL{

            @Override
            String mask(String val) {
                return DataMaskUtil.deEmail(val);
            }
        }
        ,
        NAME{

            @Override
            String mask(String val) {
                return DataMaskUtil.deName(val);
            }
        }
        ,
        ID_CARD{

            @Override
            String mask(String val) {
                return DataMaskUtil.deIdNumber(val);
            }
        }
        ,
        ADDRESS{

            @Override
            String mask(String val) {
                return DataMaskUtil.deAddress(val);
            }
        };


        String mask(String val) {
            throw new IllegalStateException();
        }
    }
}

