/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.serialization;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.jeecms.utils.UnitUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class AmountPropertySerializer
implements ObjectSerializer {
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        String r = "";
        if (object instanceof Long) {
            r = UnitUtils.convertFenToYuan((Long)object).toString();
        } else if (object instanceof Double) {
            r = UnitUtils.convertFenToYuan((Double)object).toString();
        } else if (object instanceof Float) {
            r = UnitUtils.convertFenToYuan(((Float)object).floatValue()).toString();
        } else if (object instanceof Integer) {
            r = UnitUtils.convertFenToYuan((Integer)object).toString();
        } else if (object instanceof BigDecimal) {
            r = UnitUtils.convertFenToYuan((BigDecimal)object).toString();
        }
        out.writeString(r);
    }
}

