/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.serialization;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.jeecms.serialization.Amount;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.UnitUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class AmountPropertyFilter
implements ValueFilter {
    private static final String BRANCH_NUMBER = "#,###.";
    private static final BigDecimal ONE_THOUSAND = new BigDecimal(1000);

    public Object process(Object object, String name, Object value) {
        try {
            Class<?> objectClass = object.getClass();
            Field field = null;
            try {
                field = ReflectUtil.getField(objectClass, (String)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Amount amount = null;
            if (field != null) {
                amount = field.getAnnotation(Amount.class);
            } else {
                Method method = ReflectUtil.getMethod(objectClass, (String)("get" + StrUtil.firstToUpperCase(name)), (Class[])new Class[0]);
                if (method != null) {
                    amount = method.getAnnotation(Amount.class);
                }
            }
            if (amount != null && value != null) {
                int scale = amount.scale();
                boolean toStr = amount.toStr();
                boolean toBranchNumber = amount.toBranchNumber();
                BigDecimal bigDecimal = null;
                if (value instanceof Long) {
                    bigDecimal = UnitUtils.convertFenToYuan((Long)value, scale);
                } else if (value instanceof Double) {
                    bigDecimal = UnitUtils.convertFenToYuan((Double)value, scale);
                } else if (value instanceof Float) {
                    bigDecimal = UnitUtils.convertFenToYuan(((Float)value).floatValue(), scale);
                } else if (value instanceof Integer) {
                    bigDecimal = UnitUtils.convertFenToYuan((Integer)value, scale);
                } else if (value instanceof BigDecimal) {
                    bigDecimal = UnitUtils.convertFenToYuan((BigDecimal)value, scale);
                } else if (value instanceof Iterable) {
                    ArrayList vl = new ArrayList();
                    ((Iterable)value).forEach(l -> {
                        if (l != null) {
                            BigDecimal bd = UnitUtils.convertFenToYuan(l, scale);
                            vl.add(toStr ? bd.toString() : bd);
                        }
                    });
                    return vl;
                }
                if (bigDecimal != null) {
                    if (toStr) {
                        String str = bigDecimal.toString();
                        if (bigDecimal.intValue() < 1000) {
                            return str;
                        }
                        if (toBranchNumber) {
                            StringBuffer sb = new StringBuffer(BRANCH_NUMBER);
                            for (int i = 0; i < scale; ++i) {
                                sb.append("0");
                            }
                            DecimalFormat df = new DecimalFormat(sb.toString());
                            return df.format(bigDecimal);
                        }
                        return str;
                    }
                    return bigDecimal;
                }
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }
}

