/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class RenameResource
extends AbstractResource {
    private String filename;
    private Resource resource;

    public RenameResource(Resource resource, String rename) {
        Assert.notNull((Object)rename, (String)"reFilename must not be null");
        this.filename = rename;
        this.resource = resource;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescription() {
        return this.resource.getDescription() + "    alias [" + this.filename + "]";
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isReadable() {
        return this.resource.isReadable();
    }

    public boolean isOpen() {
        return this.resource.isOpen();
    }

    public boolean isFile() {
        return this.resource.isFile();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.resource.readableChannel();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.resource.createRelative(relativePath);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RenameResource && Objects.equals(this.filename, ((RenameResource)((Object)other)).filename) && Objects.equals(this.resource, ((RenameResource)((Object)other)).resource);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.resource);
    }

    public String toString() {
        return this.getDescription();
    }
}

