/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.kit;

public class JcResult<T> {
    public static final int COMMON_SUCCESS_CODE = 200;
    public static final int COMMON_CLIENT_FAIL_CODE = 400;
    public static final int COMMON_SERVER_FAIL_CODE = 500;
    private int code;
    private String message;
    private T data;
    private String headDataJson;

    public JcResult() {
    }

    public JcResult(int code, String message, T data, String headDataJson) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.headDataJson = headDataJson;
    }

    public static <E> JcResult<E> ok(int code, String message) {
        return JcResult.build(code, message);
    }

    public static <E> JcResult<E> ok(String message, E data) {
        return JcResult.build(200, message, data);
    }

    public static <E> JcResult<E> ok(String message, E data, String headDataJson) {
        return JcResult.build(200, message, data, headDataJson);
    }

    public static <E> JcResult<E> ok(E data) {
        return JcResult.ok("\u6210\u529f", data);
    }

    public static <E> JcResult<E> ok() {
        return JcResult.ok(null);
    }

    public static <E> JcResult<E> fail(int code, String message) {
        return JcResult.build(code, message);
    }

    public static <E> JcResult<E> failMsg(String message) {
        return new JcResult<Object>(500, message, null, null);
    }

    public static <E> JcResult<E> fail(E data) {
        return JcResult.build(500, "", data);
    }

    public static <E> JcResult<E> fail() {
        return JcResult.fail(null);
    }

    public static <E> JcResult<E> build(int code, String message) {
        return new JcResult<Object>(code, message, null, null);
    }

    public static <E> JcResult<E> build(int code, String message, E data) {
        return new JcResult<E>(code, message, data, null);
    }

    public static <E> JcResult<E> build(int code, String message, E data, String headList) {
        return new JcResult<E>(code, message, data, headList);
    }

    public boolean success() {
        return this.getCode() >= 200 && this.getCode() < 300;
    }

    public boolean failed() {
        return !this.success();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public JcResult<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public JcResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public JcResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getHeadDataJson() {
        return this.headDataJson;
    }

    public void setHeadDataJson(String headDataJson) {
        this.headDataJson = headDataJson;
    }

    public String toString() {
        return "JcResult{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + ", headDataJson=" + this.headDataJson + '}';
    }
}

