/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.exception;

import com.jeecms.exception.IExceptionInfo;
import com.jeecms.utils.ReflectUtil;
import java.util.HashMap;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"dev"})
class ExceptionHelper
implements InitializingBean {
    ExceptionHelper() {
    }

    public static Throwable mayThrowable(Object ... params) {
        if (params != null && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            return (Throwable)params[params.length - 1];
        }
        return null;
    }

    public static IExceptionInfo buildExceptionInfo(int code, String message) {
        return new DefaultExceptionInfo(code, message);
    }

    public void afterPropertiesSet() {
        ExceptionHelper.validExceptionCode();
    }

    private static void validExceptionCode() {
        HashMap<Integer, IExceptionInfo> tmp = new HashMap<Integer, IExceptionInfo>(128);
        Reflections reflections = new Reflections("com.jeecms", new Scanner[0]);
        Set exceptionInfoSubTypes = reflections.getSubTypesOf(IExceptionInfo.class);
        for (Class clz : exceptionInfoSubTypes) {
            if (!clz.isEnum()) continue;
            int minCode = (Integer)ReflectUtil.getFieldValue((Object)clz, (String)"MIN_CODE");
            int maxCode = (Integer)ReflectUtil.getFieldValue((Object)clz, (String)"MAX_CODE");
            for (IExceptionInfo object : (IExceptionInfo[])clz.getEnumConstants()) {
                IExceptionInfo eInfo = object;
                int code = eInfo.getCode();
                if (tmp.containsKey(code)) {
                    throw new IllegalStateException("\u5f02\u5e38\u4ee3\u7801\u91cd\u590d: " + clz.getName() + " : " + eInfo.getCode());
                }
                if (code < minCode || code > maxCode) {
                    throw new IllegalStateException("\u5f02\u5e38\u4ee3\u7801\u4e0d\u5728\u53f7\u6bb5\u8303\u56f4\u4e4b\u4e2d: " + clz.getName() + " : " + eInfo.getCode());
                }
                tmp.put(code, eInfo);
            }
        }
    }

    static class DefaultExceptionInfo
    implements IExceptionInfo {
        private int code;
        private String message;

        DefaultExceptionInfo(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

