/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.jeecms.utils.lambda.LambdaUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TransportUtil {
    public static File downloadFromUrl(String urlStr, String savePath, boolean overwrite) throws IOException {
        return TransportUtil.downloadFromUrl(urlStr, savePath, (in, out) -> {
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                LambdaUtil.doThrow(e);
            }
        }, overwrite);
    }

    public static File downloadFromUrl(String urlStr, String savePath, Transporter transporter, boolean overwrite) throws IOException {
        File file = new File(savePath);
        if (!overwrite && file.exists()) {
            throw new IllegalArgumentException(String.format("\u6587\u4ef6\u5df2\u5b58\u5728: [%s]", file.getCanonicalPath()));
        }
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        URL url = new URL(TransportUtil.encodeUrl(urlStr));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("Host", url.getHost());
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        try (InputStream inputStream = conn.getInputStream();
             FileOutputStream fos = new FileOutputStream(file);){
            transporter.transport(inputStream, fos);
            fos.flush();
        }
        return file;
    }

    public static File downloadFromUrl(String urlStr, String savePath) throws IOException {
        return TransportUtil.downloadFromUrl(urlStr, savePath, true);
    }

    private static String encodeUrl(String urlStr) throws UnsupportedEncodingException {
        String urlBody;
        StringBuilder newUrlSb = new StringBuilder();
        String protocol = StringUtils.substringBefore((String)urlStr, (String)"://");
        newUrlSb.append(protocol).append("://");
        String hf = urlBody = StringUtils.substringAfter((String)urlStr, (String)"://");
        String param = null;
        if (urlBody.contains("?")) {
            hf = StringUtils.substringBefore((String)urlBody, (String)"?");
            param = StringUtils.substringAfter((String)urlBody, (String)"?");
        }
        String[] sfSp = hf.split("/+");
        for (int i = 0; i < sfSp.length; ++i) {
            if (i == 0) {
                newUrlSb.append(sfSp[i]).append("/");
                continue;
            }
            newUrlSb.append(URLEncoder.encode(sfSp[i], "UTF-8")).append("/");
        }
        newUrlSb.delete(newUrlSb.length() - 1, newUrlSb.length());
        if (param != null) {
            newUrlSb.append("?");
            for (String s : param.split("&")) {
                String[] paramSp = s.split("=");
                newUrlSb.append(URLEncoder.encode(paramSp[0], "UTF-8")).append("=").append(URLEncoder.encode(paramSp[1], "UTF-8"));
            }
        }
        return newUrlSb.toString();
    }

    @FunctionalInterface
    public static interface Transporter {
        public void transport(InputStream var1, OutputStream var2);
    }
}

