/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

public class ScoreUtils {
    public static final long DAY_MILLIS = 86400000L;
    private static float[] daysDampingFactor = new float[31];
    private static float demoteboost = 0.795f;
    private static int monthDay = 31;

    private static float dayDamping(int delta) {
        return delta < daysDampingFactor.length ? daysDampingFactor[delta] : daysDampingFactor[daysDampingFactor.length - 1];
    }

    public static float getNewsScoreFactor(long now, long time) {
        float factor = 1000.0f;
        int day = (int)(time / 86400000L);
        int nowDay = (int)(now / 86400000L);
        if (day < nowDay) {
            factor = ScoreUtils.dayDamping(nowDay - day);
        }
        return factor;
    }

    public static float getNewsScoreFactor(long time) {
        long now = System.currentTimeMillis();
        float scoreFactor = ScoreUtils.getNewsScoreFactor(now, time);
        return scoreFactor;
    }

    static {
        ScoreUtils.daysDampingFactor[0] = 1000.0f;
        for (int i = 1; i < monthDay; ++i) {
            ScoreUtils.daysDampingFactor[i] = daysDampingFactor[i - 1] * demoteboost;
        }
    }
}

