/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.jeecms.common.util.ProxyUtil;
import com.jeecms.utils.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    static final String PROPERTY_SPT = ".";
    private static Logger logger = LoggerFactory.getLogger(ReflectUtils.class);

    public static Object invokeGetter(Object obj, String propertyName) {
        Object object = ProxyUtil.deProxy(obj);
        for (String name : StringUtils.split((String)propertyName, (String)PROPERTY_SPT)) {
            String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)name);
            object = ReflectUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Object object = ProxyUtil.deProxy(obj);
        String[] names = StringUtils.split((String)propertyName, (String)PROPERTY_SPT);
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)names[i]);
                object = ReflectUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)names[i]);
            ReflectUtils.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Object c = ProxyUtil.deProxy(obj);
        Field field = ReflectUtils.getAccessibleField(c, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("\u5728 [" + c.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + fieldName + "] \u5b57\u6bb5 ");
        }
        Object result = null;
        try {
            result = field.get(c);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Object object = ProxyUtil.deProxy(obj);
        Field field = ReflectUtils.getAccessibleField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("\u5728 [" + object.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + fieldName + "] \u5b57\u6bb5 ");
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        if (obj == null || methodName == null) {
            return null;
        }
        Method method = ReflectUtils.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("\u5728 [" + obj.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + methodName + "] \u65b9\u6cd5 ");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            String msg = "method: " + method + ", obj: " + obj.toString();
            throw ReflectUtils.convertReflectionExceptionToUnchecked(msg, e);
        }
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectUtils.getAccessibleMethodByName(obj, methodName, args.length);
        if (method == null) {
            throw new IllegalArgumentException("\u5728 [" + obj.getClass() + "] \u4e2d\uff0c\u6ca1\u6709\u627e\u5230 [" + methodName + "] \u65b9\u6cd5 ");
        }
        try {
            Class<?>[] cs = method.getParameterTypes();
            for (int i = 0; i < cs.length; ++i) {
                if (args[i] == null || args[i].getClass().equals(cs[i])) continue;
                if (cs[i] == String.class) {
                    args[i] = ReflectUtils.convertToString(args[i]);
                    continue;
                }
                if (cs[i] == Integer.class) {
                    args[i] = ReflectUtils.convertToInteger(args[i]);
                    continue;
                }
                if (cs[i] == Long.class) {
                    args[i] = ReflectUtils.convertToLong(args[i]);
                    continue;
                }
                if (cs[i] == Double.class) {
                    args[i] = ReflectUtils.convertToDouble(args[i]);
                    continue;
                }
                if (cs[i] == Float.class) {
                    args[i] = ReflectUtils.convertToFloat(args[i]);
                    continue;
                }
                if (cs[i] != Date.class || !(args[i] instanceof String)) continue;
                args[i] = DateUtil.parseDate((CharSequence)String.valueOf(args[i]));
            }
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            String msg = "method: " + method + ", obj: " + obj;
            throw ReflectUtils.convertReflectionExceptionToUnchecked(msg, e);
        }
    }

    private static Double convertToDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return NumberUtils.toDouble((String)StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private static Float convertToFloat(Object val) {
        return Float.valueOf(ReflectUtils.convertToDouble(val).floatValue());
    }

    private static Long convertToLong(Object val) {
        return ReflectUtils.convertToDouble(val).longValue();
    }

    private static Integer convertToInteger(Object val) {
        return ReflectUtils.convertToLong(val).intValue();
    }

    private static Boolean convertToBoolean(Object val) {
        if (val == null) {
            return false;
        }
        return BooleanUtils.toBoolean((String)val.toString()) || "1".equals(val.toString());
    }

    private static String convertToString(Object obj) {
        return ReflectUtils.convertToString(obj, "");
    }

    private static String convertToString(Object obj, String defaultVal) {
        return obj == null ? defaultVal : obj.toString();
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                ReflectUtils.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName, int argsNum) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                ReflectUtils.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        boolean accessible;
        boolean bl = accessible = (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) && !method.isAccessible();
        if (accessible) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        boolean accessible;
        boolean bl = accessible = (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers()) || Modifier.isFinal(field.getModifiers())) && !field.isAccessible();
        if (accessible) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectUtils.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        if (instance == null) {
            throw new RuntimeException("Instance must not be null");
        }
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(ReflectUtils.getAllFields(superClass));
        return result;
    }

    public static List<Field> getAllFieldsExcludeTransient(Class<?> clazz) {
        LinkedList<Field> result = new LinkedList<Field>();
        List<Field> list = ReflectUtils.getAllFields(clazz);
        for (Field field : list) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            result.add(field);
        }
        return result;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws Exception {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getSuperclass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e1) {
                try {
                    field = clazz.getSuperclass().getSuperclass().getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e2) {
                    throw new Exception("Not Found Field\uff1a" + fieldName + " in Class " + clazz.getName() + " and super Class.");
                }
            }
        }
        if (field == null) {
            throw new Exception("Not Found Field\uff1a" + fieldName + " in Class " + clazz.getName() + " and super Class.");
        }
        return field;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(String msg, Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(msg, e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(msg, ((InvocationTargetException)e).getTargetException());
        }
        return new RuntimeException(msg, e);
    }
}

