/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class MyDateUtils
extends DateUtils {
    public static final String COM_YM_PATTERN = "yyyyMM";
    public static final String COM_D_H_M_S_PATTERN = "ddHHmmss";
    public static final String COM_YMD_PATTERN = "yyyyMMdd";
    public static final String COM_Y_PATTERN = "yyyy";
    public static final String COM_Y_M_PATTERN = "yyyy-MM";
    public static final String COM_Y_M_D_PATTERN = "yyyy-MM-dd";
    public static final String COM_YMDHMS_PATTERN = "yyyyMMdd HH:mm:ss";
    public static final String COM_Y_M_D_H_M_S_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String COM_H_M_PATTERN = "HH:mm";
    public static final String COM_H_PATTERN = "HH";
    public static final String COM_Y_M_D_H_M_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String COM_SECOND_PATTERN = "yyMMddHHmmss";
    public static final String COM_MILLISECOND_PATTERN = "yyyyMMddHHmmssmmmm";
    public static final String COM_TIME_ZONE_PATTERN = "EEE MMM dd HH:mm:ss Z yyyy";

    private MyDateUtils() {
    }

    public static Date parseDate(String dateStr, String pattern) {
        try {
            return FastDateFormat.getInstance((String)pattern).parse(dateStr);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static Date parseDate(String dateStr) {
        try {
            return FastDateFormat.getInstance((String)COM_Y_M_D_PATTERN).parse(dateStr);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static String formatDate(Date date, String pattern) {
        return FastDateFormat.getInstance((String)pattern).format(date);
    }

    public static String formatDate(Date date) {
        return FastDateFormat.getInstance((String)COM_Y_M_D_PATTERN).format(date);
    }

    private static int getDateField(Date date, int field) {
        Calendar c = MyDateUtils.getCalendar();
        c.setTime(date);
        return c.get(field);
    }

    public static Integer getSecondBetweenDate(Date d1, Date d2) {
        Long second = (d2.getTime() - d1.getTime()) / 1000L;
        return second.intValue();
    }

    public static Double getDiffMinuteTwoDate(Date begin, Date end) {
        return (double)((end.getTime() - begin.getTime()) / 1000L) / 60.0;
    }

    public static Integer getDiffIntMinuteTwoDate(Date begin, Date end) {
        return (int)((end.getTime() - begin.getTime()) / 1000L / 60L);
    }

    public static Double getDiffHourTwoDate(Date begin, Date end) {
        return MyDateUtils.getDiffMinuteTwoDate(begin, end) / 60.0;
    }

    public static Double getDiffDayTwoDate(Date begin, Date end) {
        return MyDateUtils.getDiffMinuteTwoDate(begin, end) / 1440.0;
    }

    public static Integer getDiffIntHourTwoDate(Date begin, Date end) {
        return MyDateUtils.getDiffHourTwoDate(begin, end).intValue();
    }

    public static int getYearsBetweenDate(Date begin, Date end) {
        int bYear = MyDateUtils.getDateField(begin, 1);
        int eYear = MyDateUtils.getDateField(end, 1);
        return eYear - bYear;
    }

    public static int getDaysBetweenDate(Date begin, Date end) {
        return (int)((end.getTime() - begin.getTime()) / 86400000L);
    }

    public static Date getSpecficYearStart(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, amount);
        cal.set(6, 1);
        return MyDateUtils.getStartDate(cal.getTime());
    }

    public static Date getSpecficYearEnd(Date date, int amount) {
        Date temp = MyDateUtils.getStartDate(MyDateUtils.getSpecficYearStart(date, amount + 1));
        Calendar cal = Calendar.getInstance();
        cal.setTime(temp);
        cal.add(6, -1);
        return MyDateUtils.getFinallyDate(cal.getTime());
    }

    public static Date getSpecficMonthStart(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, amount);
        cal.set(5, 1);
        return MyDateUtils.getStartDate(cal.getTime());
    }

    public static Date getSpecficMonthEnd(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(MyDateUtils.getSpecficMonthStart(date, amount + 1));
        cal.add(6, -1);
        return MyDateUtils.getFinallyDate(cal.getTime());
    }

    public static Date getSpecficWeekStart(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.add(4, amount);
        cal.set(7, 2);
        return MyDateUtils.getStartDate(cal.getTime());
    }

    public static Date getSpecficWeekEnd(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.add(4, amount);
        cal.set(7, 1);
        return MyDateUtils.getFinallyDate(cal.getTime());
    }

    public static Date getSpecficDateStart(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, amount);
        return MyDateUtils.getStartDate(cal.getTime());
    }

    public static Date getSpecficDateEnd(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, amount);
        return MyDateUtils.getFinallyDate(cal.getTime());
    }

    public static Date getSpecficDate(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, amount);
        return cal.getTime();
    }

    public static Date getFinallyDate(Date date) {
        String temp = FastDateFormat.getInstance((String)COM_YMD_PATTERN).format(date);
        temp = temp + " 23:59:59";
        try {
            return FastDateFormat.getInstance((String)COM_YMDHMS_PATTERN).parse(temp);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static Date getStartDate(Date date) {
        String temp = FastDateFormat.getInstance((String)COM_YMD_PATTERN).format(date);
        temp = temp + " 00:00:00";
        try {
            return FastDateFormat.getInstance((String)COM_YMDHMS_PATTERN).parse(temp);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date getMinuteBeforeTime(Date date, int minute) {
        Date beforeTime = new Date(date.getTime() - (long)(60000 * minute));
        return beforeTime;
    }

    public static Date getMinuteAfterTime(Date date, int minute) {
        Date beforeTime = new Date(date.getTime() + (long)(60000 * minute));
        return beforeTime;
    }

    public static Date getHourAfterTime(Date date, int hour) {
        Date beforeTime = new Date(date.getTime() + (long)(3600000 * hour));
        return beforeTime;
    }

    public static Date getDayAfterTime(Date date, int day) {
        Date beforeTime = new Date(date.getTime() + (long)(86400000 * day));
        return beforeTime;
    }

    public static Date getSecondAfterTime(Date date, int second) {
        Date beforeTime = new Date(date.getTime() + (long)(1000 * second));
        return beforeTime;
    }

    public static boolean isInDate(Date date, Date compareDate) {
        boolean isInDate;
        int compare = compareDate.compareTo(date);
        boolean bl = isInDate = compareDate.after(MyDateUtils.getStartDate(date)) && compareDate.before(MyDateUtils.getFinallyDate(date)) || compare == 0;
        return isInDate;
    }

    public static int getYear(Calendar calendar) {
        return calendar.get(1);
    }

    public static int getMonth(Calendar calendar) {
        return calendar.get(2) + 1;
    }

    public static int getDate(Calendar calendar) {
        return calendar.get(5);
    }

    public static int getHour(Calendar calendar) {
        return calendar.get(11);
    }

    public static int getMinute(Calendar calendar) {
        return calendar.get(12);
    }

    public static int getSecond(Calendar calendar) {
        return calendar.get(13);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static List<String> getMonths(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(COM_Y_M_PATTERN);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(2, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(COM_Y_M_D_PATTERN);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static synchronized Date parseTimeDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(COM_TIME_ZONE_PATTERN, Locale.US);
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTime(Date releaseTime) {
        Date today = Calendar.getInstance().getTime();
        int dayDiff = MyDateUtils.getDaysBetweenDate(releaseTime, today);
        int hourDiff = MyDateUtils.getDiffIntHourTwoDate(releaseTime, today);
        int minuteDiff = MyDateUtils.getDiffIntMinuteTwoDate(releaseTime, today);
        if (dayDiff >= 3) {
            return MyDateUtils.formatDate(releaseTime, COM_Y_M_D_H_M_PATTERN);
        }
        if (dayDiff >= 2) {
            return "\u524d\u5929";
        }
        if (dayDiff >= 1) {
            return "\u6628\u5929";
        }
        if (hourDiff >= 1) {
            return hourDiff + "\u5c0f\u65f6\u524d";
        }
        if (minuteDiff >= 1) {
            return minuteDiff + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static String secToTime(int time) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00:00";
        }
        if (time >= 3600) {
            hour = time / 3600;
            time %= 3600;
        }
        if (time >= 60) {
            minute = time / 60;
            second = time % 60;
        }
        return MyDateUtils.timeFormat(hour) + ":" + MyDateUtils.timeFormat(minute) + ":" + MyDateUtils.timeFormat(second);
    }

    public static String timeFormat(int num) {
        String retStr = null;
        retStr = num >= 0 && num < 10 ? "0" + Integer.toString(num) : "" + num;
        return retStr;
    }

    public static List<String> betweenTime(int showType, Date beginTime, Date endTime) {
        ArrayList<String> list = new ArrayList();
        switch (showType) {
            case 2: {
                list = MyDateUtils.getDays(MyDateUtils.formatDate(beginTime), MyDateUtils.formatDate(endTime));
                break;
            }
            case 3: {
                int weekLen = 7;
                for (int i = 0; i < weekLen; ++i) {
                    list.add(String.valueOf(i));
                }
                break;
            }
            case 4: {
                list = MyDateUtils.getMonths(MyDateUtils.formatDate(beginTime), MyDateUtils.formatDate(endTime));
                break;
            }
            default: {
                int len = 24;
                for (int i = 0; i < len; ++i) {
                    list.add(i > 9 ? String.valueOf(i) : "0" + i);
                }
            }
        }
        return list;
    }

    public static Map<Date, Date> groupByMonth(Date startDate, Date endDate) {
        LinkedHashMap<Date, Date> dateMap = new LinkedHashMap<Date, Date>();
        Date firstDay = null;
        Date lastDay = null;
        Calendar dd = Calendar.getInstance();
        dd.setTime(startDate);
        Calendar cale = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        int startDay = startDate.getDate();
        int endDay = endDate.getDate();
        while (dd.getTime().before(endDate)) {
            cale.setTime(dd.getTime());
            if (dd.getTime().equals(startDate)) {
                cale.set(5, dd.getActualMaximum(5));
                lastDay = cale.getTime();
                dateMap.put(startDate, lastDay);
            } else if (dd.get(2) == endDate.getMonth() && dd.get(1) == c.get(1)) {
                cale.set(5, 1);
                firstDay = cale.getTime();
                dateMap.put(firstDay, endDate);
            } else {
                cale.set(5, 1);
                firstDay = cale.getTime();
                cale.set(5, dd.getActualMaximum(5));
                lastDay = cale.getTime();
                dateMap.put(firstDay, lastDay);
            }
            dd.add(2, 1);
        }
        if (endDay < startDay) {
            cale.setTime(endDate);
            cale.set(5, 1);
            firstDay = cale.getTime();
            dateMap.put(firstDay, endDate);
        }
        return dateMap;
    }

    public static Map<Date, Date> groupByWeek(Date startTime, Date endTime) {
        Date s;
        LinkedHashMap<Date, Date> dateMap = new LinkedHashMap<Date, Date>();
        Calendar cl1 = Calendar.getInstance();
        cl1.setTime(startTime);
        Calendar cl2 = Calendar.getInstance();
        cl2.setTime(endTime);
        Calendar cl3 = Calendar.getInstance();
        if (cl1.get(7) - 1 == 1) {
            cl1.add(5, 6);
        } else {
            cl1.add(5, 8 - cl1.get(7));
        }
        dateMap.put(MyDateUtils.getStartDate(startTime), MyDateUtils.getStartDate(cl1.getTime()));
        while (cl3.getTime().getTime() < cl2.getTime().getTime()) {
            cl1.add(5, 1);
            s = cl1.getTime();
            cl1.add(5, 6);
            dateMap.put(MyDateUtils.getStartDate(s), MyDateUtils.getFinallyDate(cl1.getTime()));
            cl3.setTime(cl1.getTime());
            cl3.add(5, 7);
        }
        cl1.add(5, 1);
        s = cl1.getTime();
        if (cl1.getTime().equals(endTime)) {
            dateMap.put(MyDateUtils.getStartDate(s), MyDateUtils.getFinallyDate(s));
        } else {
            dateMap.put(MyDateUtils.getStartDate(s), MyDateUtils.getFinallyDate(endTime));
        }
        return dateMap;
    }
}

