/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import com.jeecms.utils.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtil.class);

    public static File download(String urlStr, String savePath, boolean overwrite) {
        File file = new File(savePath + File.separator + DownloadUtil.getFilenameFromUrl(urlStr));
        return DownloadUtil.download(urlStr, file, overwrite);
    }

    public static File download(String urlStr, File saveFile, boolean overwrite) {
        return DownloadUtil.download(urlStr, saveFile, (InputStream in, OutputStream out) -> IoUtil.copy((InputStream)in, (OutputStream)out), overwrite);
    }

    public static File download(String urlStr, String savePath, Transporter transporter, boolean overwrite) {
        return DownloadUtil.download(urlStr, new File(savePath), transporter, overwrite);
    }

    public static File download(String urlStr, File file, Transporter transporter, boolean overwrite) {
        try {
            if (!overwrite && file.exists()) {
                throw new IllegalArgumentException(String.format("\u6587\u4ef6\u5df2\u5b58\u5728: [%s]", file.getCanonicalPath()));
            }
            FileUtil.touch((File)file);
            URL url = new URL(DownloadUtil.encodeUrl(urlStr));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            try (InputStream inputStream = conn.getInputStream();
                 FileOutputStream fos = new FileOutputStream(file);){
                transporter.transport(inputStream, fos);
                fos.flush();
            }
            log.debug("{} download success", (Object)urlStr);
            return file;
        }
        catch (IOException e) {
            log.warn("{} download fail", (Object)urlStr);
            throw new RuntimeException(e);
        }
    }

    public static File download(String urlStr, String savePath) {
        return DownloadUtil.download(urlStr, savePath, true);
    }

    public static File download(String urlStr, File saveFile) {
        return DownloadUtil.download(urlStr, saveFile, true);
    }

    public static File download(String urlStr) {
        File tempFile = FileUtil.createTempFile();
        DownloadUtil.download(urlStr, tempFile, true);
        File file = FileUtil.renameToRealType(tempFile);
        return file;
    }

    public static File downloadAndFixFilename(String urlStr, String saveDir) {
        File downloadFile = DownloadUtil.download(urlStr, saveDir);
        File file = FileUtil.renameToRealType(downloadFile);
        return file;
    }

    private static String encodeUrl(String urlStr) throws UnsupportedEncodingException {
        String urlBody;
        StringBuilder newUrlSb = new StringBuilder();
        String protocol = StringUtils.substringBefore((String)urlStr, (String)"://");
        newUrlSb.append(protocol).append("://");
        String hf = urlBody = StringUtils.substringAfter((String)urlStr, (String)"://");
        String param = null;
        if (urlBody.contains("?")) {
            hf = StringUtils.substringBefore((String)urlBody, (String)"?");
            param = StringUtils.substringAfter((String)urlBody, (String)"?");
        }
        String[] sfSp = hf.split("/+");
        for (int i = 0; i < sfSp.length; ++i) {
            if (i == 0) {
                newUrlSb.append(sfSp[i]).append("/");
                continue;
            }
            newUrlSb.append(URLUtil.encode((String)sfSp[i])).append("/");
        }
        newUrlSb.delete(newUrlSb.length() - 1, newUrlSb.length());
        if (param != null) {
            newUrlSb.append("?");
            for (String s : param.split("&")) {
                String[] paramSp = s.split("=");
                newUrlSb.append(URLUtil.encode((String)paramSp[0])).append("=").append(URLUtil.encode((String)paramSp[1])).append("&");
            }
            newUrlSb.delete(newUrlSb.length() - 1, newUrlSb.length());
        }
        return newUrlSb.toString();
    }

    private static String getFilenameFromUrl(String urlStr) {
        String substring = urlStr.substring(urlStr.lastIndexOf("/") + 1);
        int idx = substring.indexOf("?");
        if (idx > 0) {
            substring = substring.substring(0, idx);
        }
        return substring;
    }

    @FunctionalInterface
    public static interface Transporter {
        public void transport(InputStream var1, OutputStream var2);
    }
}

