/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.io.UnsupportedEncodingException;

public final class ChineseCharToEn {
    private static final int[] LI_SECPOS_VALUE = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] LC_FIRST_LETTE = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "w", "x", "y", "z"};

    public static String getAllFirstLetter(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        String strTarget = "";
        for (int i = 0; i < str.length(); ++i) {
            strTarget = strTarget + ChineseCharToEn.getFirstLetter(str.substring(i, i + 1));
        }
        return strTarget;
    }

    public static String getFirstLetter(String chinese) {
        if (chinese == null || chinese.trim().length() == 0) {
            return "";
        }
        if ((chinese = ChineseCharToEn.conversionStr(chinese, "GB2312", "ISO8859-1")).length() > 1) {
            int liSectorCode = chinese.charAt(0);
            int liPositionCode = chinese.charAt(1);
            int liSecPosCode = (liSectorCode -= 160) * 100 + (liPositionCode -= 160);
            int liSecPosCodeFirst = 1600;
            int liSecPosCodeLast = 5590;
            int forNum = 23;
            if (liSecPosCode > liSecPosCodeFirst && liSecPosCode < liSecPosCodeLast) {
                for (int i = 0; i < forNum; ++i) {
                    if (liSecPosCode < LI_SECPOS_VALUE[i] || liSecPosCode >= LI_SECPOS_VALUE[i + 1]) continue;
                    chinese = LC_FIRST_LETTE[i];
                    break;
                }
            } else {
                chinese = ChineseCharToEn.conversionStr(chinese, "ISO8859-1", "GB2312");
                chinese = chinese.substring(0, 1);
            }
        }
        return chinese;
    }

    private static String conversionStr(String str, String charsetName, String toCharsetName) {
        try {
            str = new String(str.getBytes(charsetName), toCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        return str;
    }
}

