/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.specification;

import com.jayway.restassured.internal.assertion.AssertParameter;
import org.apache.commons.lang3.StringUtils;

public class ProxySpecification {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String DEFAULT_SCHEME = "http";
    private static final int DEFAULT_PORT = 8888;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final String host;
    private final int port;
    private final String scheme;

    public ProxySpecification(String host, int port, String scheme) {
        this.host = StringUtils.trimToNull((String)host);
        this.scheme = StringUtils.trimToNull((String)scheme);
        AssertParameter.notNull((Object)this.host, (String)"Proxy host");
        AssertParameter.notNull((Object)this.scheme, (String)"Proxy scheme");
        if (port < 1) {
            if (scheme.equalsIgnoreCase("http")) {
                port = 80;
            } else if (scheme.equalsIgnoreCase(HTTPS)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Cannot determine proxy port");
            }
        }
        this.port = port;
    }

    public static ProxySpecification host(String host) {
        return new ProxySpecification(host, 8888, "http");
    }

    public static ProxySpecification port(int port) {
        return new ProxySpecification(DEFAULT_HOST, port, "http");
    }

    public ProxySpecification withPort(int port) {
        return new ProxySpecification(this.host, port, this.scheme);
    }

    public ProxySpecification withHost(String host) {
        return new ProxySpecification(host, this.port, this.scheme);
    }

    public ProxySpecification withScheme(String scheme) {
        return new ProxySpecification(this.host, this.port, scheme);
    }

    public ProxySpecification and() {
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySpecification that = (ProxySpecification)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.scheme + "://" + this.host + ":" + this.port;
    }
}

