/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.print;

import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.NoParameterValue;
import com.jayway.restassured.internal.support.Prettifier;
import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.MultiPartSpecification;
import com.jayway.restassured.specification.ProxySpecification;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPrinter {
    private static final String TAB = "\t";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EQUALS = "=";
    private static final String NONE = "<none>";

    public static String print(FilterableRequestSpecification requestSpec, String requestMethod, String completeRequestPath, LogDetail logDetail, PrintStream stream, boolean shouldPrettyPrint) {
        String logString;
        StringBuilder builder = new StringBuilder();
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.METHOD) {
            RequestPrinter.addSingle(builder, "Request method:", requestMethod);
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.PATH) {
            RequestPrinter.addSingle(builder, "Request path:", completeRequestPath);
        }
        if (logDetail == LogDetail.ALL) {
            RequestPrinter.addProxy(requestSpec, builder);
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.PARAMS) {
            RequestPrinter.addMapDetails(builder, "Request params:", requestSpec.getRequestParams());
            RequestPrinter.addMapDetails(builder, "Query params:", requestSpec.getQueryParams());
            RequestPrinter.addMapDetails(builder, "Form params:", requestSpec.getFormParams());
            RequestPrinter.addMapDetails(builder, "Path params:", requestSpec.getPathParams());
            RequestPrinter.addMultiParts(requestSpec, builder);
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.HEADERS) {
            RequestPrinter.addHeaders(requestSpec, builder);
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.COOKIES) {
            RequestPrinter.addCookies(requestSpec, builder);
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.BODY) {
            RequestPrinter.addBody(requestSpec, builder, shouldPrettyPrint);
        }
        if ((logString = builder.toString()).endsWith("\n")) {
            logString = StringUtils.removeEnd((String)logString, (String)"\n");
        }
        stream.println(logString);
        return logString;
    }

    private static void addProxy(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Proxy:");
        ProxySpecification proxySpec = requestSpec.getProxySpecification();
        RequestPrinter.appendThreeTabs(builder);
        if (proxySpec == null) {
            builder.append(NONE);
        } else {
            builder.append(proxySpec.toString());
        }
        builder.append(NEW_LINE);
    }

    private static void addBody(FilterableRequestSpecification requestSpec, StringBuilder builder, boolean shouldPrettyPrint) {
        builder.append("Body:");
        if (requestSpec.getBody() != null) {
            String body = shouldPrettyPrint ? new Prettifier().getPrettifiedBodyIfPossible(requestSpec) : (String)requestSpec.getBody();
            builder.append(NEW_LINE).append(body);
        } else {
            RequestPrinter.appendTab(RequestPrinter.appendTwoTabs(builder)).append(NONE);
        }
    }

    private static void addCookies(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Cookies:");
        Cookies cookies = requestSpec.getCookies();
        if (!cookies.exist()) {
            RequestPrinter.appendTwoTabs(builder).append(NONE).append(NEW_LINE);
        }
        int i = 0;
        for (Cookie cookie : cookies) {
            if (i++ == 0) {
                RequestPrinter.appendTwoTabs(builder);
            } else {
                RequestPrinter.appendFourTabs(builder);
            }
            builder.append(cookie).append(NEW_LINE);
        }
    }

    private static void addHeaders(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Headers:");
        Headers headers = requestSpec.getHeaders();
        if (!headers.exist()) {
            RequestPrinter.appendTwoTabs(builder).append(NONE).append(NEW_LINE);
        } else {
            int i = 0;
            for (Header header : headers) {
                if (i++ == 0) {
                    RequestPrinter.appendTwoTabs(builder);
                } else {
                    RequestPrinter.appendFourTabs(builder);
                }
                builder.append(header).append(NEW_LINE);
            }
        }
    }

    private static void addMultiParts(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Multiparts:");
        List<MultiPartSpecification> multiParts = requestSpec.getMultiPartParams();
        if (multiParts.isEmpty()) {
            RequestPrinter.appendTwoTabs(builder).append(NONE).append(NEW_LINE);
        } else {
            int i = 0;
            for (MultiPartSpecification multiPart : multiParts) {
                if (i++ == 0) {
                    RequestPrinter.appendTwoTabs(builder);
                } else {
                    RequestPrinter.appendFourTabs(builder);
                }
                builder.append(multiPart).append(NEW_LINE);
            }
        }
    }

    private static void addSingle(StringBuilder builder, String str, String requestPath) {
        RequestPrinter.appendTab(builder.append(str)).append(requestPath).append(NEW_LINE);
    }

    private static void addMapDetails(StringBuilder builder, String title, Map<String, ?> map) {
        RequestPrinter.appendTab(builder.append(title));
        if (map.isEmpty()) {
            builder.append(NONE).append(NEW_LINE);
        } else {
            int i = 0;
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (i++ != 0) {
                    RequestPrinter.appendFourTabs(builder);
                }
                Object value = entry.getValue();
                builder.append(entry.getKey());
                if (!(value instanceof NoParameterValue)) {
                    builder.append(EQUALS).append(value);
                }
                builder.append(NEW_LINE);
            }
        }
    }

    private static StringBuilder appendFourTabs(StringBuilder builder) {
        RequestPrinter.appendTwoTabs(RequestPrinter.appendTwoTabs(builder));
        return builder;
    }

    private static StringBuilder appendTwoTabs(StringBuilder builder) {
        RequestPrinter.appendTab(RequestPrinter.appendTab(builder));
        return builder;
    }

    private static StringBuilder appendThreeTabs(StringBuilder builder) {
        RequestPrinter.appendTwoTabs(RequestPrinter.appendTab(builder));
        return builder;
    }

    private static StringBuilder appendTab(StringBuilder builder) {
        return builder.append(TAB);
    }
}

