/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.request.encrypt.request;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.security.guomi.GuomiUtil;
import cn.stylefeng.roses.kernel.security.request.encrypt.exception.enums.EncryptionExceptionEnum;
import cn.stylefeng.roses.kernel.security.request.encrypt.holder.TempSm4KeyHolder;
import cn.stylefeng.roses.kernel.security.request.encrypt.pojo.EncryptionDTO;
import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;

public class CustomDecryptHttpInputMessage
implements HttpInputMessage {
    private final HttpHeaders originalHeaders;
    private final String originalBodyJsonString;

    public CustomDecryptHttpInputMessage(HttpHeaders originalHeaders, String originalBodyJsonString) {
        this.originalHeaders = originalHeaders;
        this.originalBodyJsonString = originalBodyJsonString;
    }

    public InputStream getBody() {
        EncryptionDTO encryptionDTO = (EncryptionDTO)JSON.parseObject((String)this.originalBodyJsonString, EncryptionDTO.class);
        if (encryptionDTO == null) {
            throw new ServiceException((AbstractExceptionEnum)EncryptionExceptionEnum.RSA_DECRYPT_ERROR);
        }
        if (StrUtil.isBlank((CharSequence)encryptionDTO.getPassedKey()) || StrUtil.isBlank((CharSequence)encryptionDTO.getPassedData())) {
            throw new ServiceException((AbstractExceptionEnum)EncryptionExceptionEnum.RSA_DECRYPT_ERROR);
        }
        String passedKey = encryptionDTO.getPassedKey();
        String sm4Key = GuomiUtil.sm2DecryptWithPrivate((String)passedKey);
        TempSm4KeyHolder.setSm4Key(sm4Key);
        String passedData = encryptionDTO.getPassedData();
        SM4 sm4 = SmUtil.sm4((byte[])sm4Key.getBytes());
        String decryptAfterData = sm4.decryptStr(passedData, StandardCharsets.UTF_8);
        return new ByteArrayInputStream(decryptAfterData.getBytes(CharsetUtil.CHARSET_UTF_8));
    }

    public HttpHeaders getHeaders() {
        return this.originalHeaders;
    }
}

