/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import com.itextpdf.svg.renderers.path.impl.DefaultOperatorConverter;
import com.itextpdf.svg.renderers.path.impl.IControlPointCurve;
import com.itextpdf.svg.renderers.path.impl.IOperatorConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CurveTo
extends AbstractPathShape
implements IControlPointCurve {
    static final int ARGUMENT_SIZE = 6;
    private static double ZERO_EPSILON = 1.0E-12;

    public CurveTo() {
        this(false);
    }

    public CurveTo(boolean relative) {
        this(relative, new DefaultOperatorConverter());
    }

    public CurveTo(boolean relative, IOperatorConverter copier) {
        super(relative, copier);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x1 = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[0]);
        float y1 = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[1]);
        float x2 = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[2]);
        float y2 = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[3]);
        float x = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[4]);
        float y = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[5]);
        canvas.curveTo((double)x1, (double)y1, (double)x2, (double)y2, (double)x, (double)y);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length < 6) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x1 y1 x2 y2 x y)+ parameters are expected for curves. Got: {0}", (Object[])new Object[]{Arrays.toString(inputCoordinates)}));
        }
        this.coordinates = new String[6];
        System.arraycopy(inputCoordinates, 0, this.coordinates, 0, 6);
        double[] initialPoint = new double[]{startPoint.getX(), startPoint.getY()};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, initialPoint);
        }
    }

    @Override
    public Point getLastControlPoint() {
        return this.createPoint(this.coordinates[2], this.coordinates[3]);
    }

    @Override
    public Rectangle getPathShapeRectangle(Point lastPoint) {
        Point firstControlPoint = this.getFirstControlPoint();
        Point lastControlPoint = this.getLastControlPoint();
        Point endingPoint = this.getEndingPoint();
        double[] points = CurveTo.getBezierMinMaxPoints(lastPoint.getX(), lastPoint.getY(), firstControlPoint.getX(), firstControlPoint.getY(), lastControlPoint.getX(), lastControlPoint.getY(), endingPoint.getX(), endingPoint.getY());
        return new Rectangle((float)CssUtils.convertPxToPts((double)points[0]), (float)CssUtils.convertPxToPts((double)points[1]), (float)CssUtils.convertPxToPts((double)(points[2] - points[0])), (float)CssUtils.convertPxToPts((double)(points[3] - points[1])));
    }

    private Point getFirstControlPoint() {
        return this.createPoint(this.coordinates[0], this.coordinates[1]);
    }

    private static double[] getBezierMinMaxPoints(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double[] extremeTValues;
        double xMin = Math.min(x0, x3);
        double yMin = Math.min(y0, y3);
        double xMax = Math.max(x0, x3);
        double yMax = Math.max(y0, y3);
        for (double t : extremeTValues = CurveTo.getTValuesInExtremePoints(x0, y0, x1, y1, x2, y2, x3, y3)) {
            double xValue = CurveTo.calculateExtremeCoordinate(t, x0, x1, x2, x3);
            double yValue = CurveTo.calculateExtremeCoordinate(t, y0, y1, y2, y3);
            xMin = Math.min(xValue, xMin);
            yMin = Math.min(yValue, yMin);
            xMax = Math.max(xValue, xMax);
            yMax = Math.max(yValue, yMax);
        }
        return new double[]{xMin, yMin, xMax, yMax};
    }

    private static double[] getTValuesInExtremePoints(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        ArrayList<Double> tValuesList = new ArrayList<Double>(CurveTo.calculateTValues(x0, x1, x2, x3));
        tValuesList.addAll(CurveTo.calculateTValues(y0, y1, y2, y3));
        double[] tValuesArray = new double[tValuesList.size()];
        for (int i = 0; i < tValuesList.size(); ++i) {
            tValuesArray[i] = (Double)tValuesList.get(i);
        }
        return tValuesArray;
    }

    private static List<Double> calculateTValues(double p0, double p1, double p2, double p3) {
        ArrayList<Double> tValuesList = new ArrayList<Double>();
        double a = (-p0 + 3.0 * p1 - 3.0 * p2 + p3) * 3.0;
        double b = (3.0 * p0 - 6.0 * p1 + 3.0 * p2) * 2.0;
        double c = 3.0 * p1 - 3.0 * p0;
        if (Math.abs(a) < ZERO_EPSILON) {
            if (Math.abs(b) >= ZERO_EPSILON) {
                CurveTo.addTValueToList(-c / b, tValuesList);
            }
        } else {
            double discriminant = b * b - 4.0 * c * a;
            if (discriminant <= 0.0 && Math.abs(discriminant) < ZERO_EPSILON) {
                CurveTo.addTValueToList(-b / (2.0 * a), tValuesList);
            } else {
                double discriminantSqrt = Math.sqrt(discriminant);
                CurveTo.addTValueToList((-b + discriminantSqrt) / (2.0 * a), tValuesList);
                CurveTo.addTValueToList((-b - discriminantSqrt) / (2.0 * a), tValuesList);
            }
        }
        return tValuesList;
    }

    private static void addTValueToList(double t, List<Double> tValuesList) {
        if (0.0 <= t && t <= 1.0) {
            tValuesList.add(t);
        }
    }

    private static double calculateExtremeCoordinate(double t, double p0, double p1, double p2, double p3) {
        double minusT = 1.0 - t;
        return minusT * minusT * minusT * p0 + 3.0 * minusT * minusT * t * p1 + 3.0 * minusT * t * t * p2 + t * t * t * p3;
    }
}

