/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.processors.impl;

import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.ITextNode;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.css.impl.SvgStyleResolver;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessor;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.ProcessorState;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import com.itextpdf.svg.processors.impl.SvgProcessorContext;
import com.itextpdf.svg.processors.impl.SvgProcessorResult;
import com.itextpdf.svg.processors.impl.font.SvgFontProcessor;
import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.factories.ISvgNodeRendererFactory;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.NoDrawOperationSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextLeafSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import com.itextpdf.svg.utils.SvgTextUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DefaultSvgProcessor
implements ISvgProcessor {
    private ProcessorState processorState;
    private ICssResolver cssResolver;
    private ISvgNodeRendererFactory rendererFactory;
    private Map<String, ISvgNodeRenderer> namedObjects;
    private SvgCssContext cssContext;
    private SvgProcessorContext context;

    @Override
    public ISvgProcessorResult process(INode root, ISvgConverterProperties converterProps) throws SvgProcessingException {
        if (root == null) {
            throw new SvgProcessingException("Input root value is null");
        }
        if (converterProps == null) {
            converterProps = new SvgConverterProperties();
        }
        this.performSetup(root, converterProps);
        IElementNode svgRoot = this.findFirstElement(root, "svg");
        if (svgRoot != null) {
            this.executeDepthFirstTraversal((INode)svgRoot);
            ISvgNodeRenderer rootSvgRenderer = this.createResultAndClean();
            return new SvgProcessorResult(this.namedObjects, rootSvgRenderer, this.context.getFontProvider(), this.context.getTempFonts());
        }
        throw new SvgProcessingException("No root found");
    }

    public ISvgProcessorResult process(INode root) throws SvgProcessingException {
        return this.process(root, null);
    }

    void performSetup(INode root, ISvgConverterProperties converterProps) {
        this.processorState = new ProcessorState();
        if (converterProps.getRendererFactory() != null) {
            this.rendererFactory = converterProps.getRendererFactory();
        }
        this.context = new SvgProcessorContext(converterProps);
        this.cssResolver = new SvgStyleResolver(root, this.context);
        new SvgFontProcessor(this.context).addFontFaceFonts(this.cssResolver);
        this.namedObjects = new HashMap<String, ISvgNodeRenderer>();
        this.cssContext = new SvgCssContext();
    }

    void executeDepthFirstTraversal(INode startingNode) {
        IElementNode rootElementNode;
        ISvgNodeRenderer startingRenderer;
        if (startingNode instanceof IElementNode && !this.rendererFactory.isTagIgnored((IElementNode)startingNode) && (startingRenderer = this.rendererFactory.createSvgNodeRendererForTag(rootElementNode = (IElementNode)startingNode, null)) != null) {
            Map attributesAndStyles = this.cssResolver.resolveStyles(startingNode, (AbstractCssContext)this.cssContext);
            rootElementNode.setStyles(attributesAndStyles);
            startingRenderer.setAttributesAndStyles(attributesAndStyles);
            this.processorState.push(startingRenderer);
            for (INode rootChild : startingNode.childNodes()) {
                this.visit(rootChild);
            }
        }
    }

    private ISvgNodeRenderer createResultAndClean() {
        return this.processorState.pop();
    }

    private void visit(INode node) {
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            if (!this.rendererFactory.isTagIgnored(element)) {
                ISvgNodeRenderer renderer = this.createRenderer(element, this.processorState.top());
                if (renderer != null) {
                    Map styles = this.cssResolver.resolveStyles(node, (AbstractCssContext)this.cssContext);
                    element.setStyles(styles);
                    renderer.setAttributesAndStyles(styles);
                    String attribute = renderer.getAttribute("id");
                    if (attribute != null) {
                        this.namedObjects.put(attribute, renderer);
                    }
                    if (!(renderer instanceof NoDrawOperationSvgNodeRenderer)) {
                        if (this.processorState.top() instanceof IBranchSvgNodeRenderer) {
                            ((IBranchSvgNodeRenderer)this.processorState.top()).addChild(renderer);
                        } else if (this.processorState.top() instanceof TextSvgBranchRenderer && renderer instanceof ISvgTextNodeRenderer) {
                            ((TextSvgBranchRenderer)this.processorState.top()).addChild((ISvgTextNodeRenderer)renderer);
                        }
                    }
                    this.processorState.push(renderer);
                }
                for (INode childNode : element.childNodes()) {
                    this.visit(childNode);
                }
                if (renderer != null) {
                    this.processorState.pop();
                }
            }
        } else if (this.processAsText(node)) {
            this.processText((ITextNode)node);
        }
    }

    private ISvgNodeRenderer createRenderer(IElementNode tag, ISvgNodeRenderer parent) {
        return this.rendererFactory.createSvgNodeRendererForTag(tag, parent);
    }

    private boolean processAsText(INode node) {
        return node instanceof ITextNode;
    }

    private void processText(ITextNode textNode) {
        String wholeText;
        ISvgNodeRenderer parentRenderer = this.processorState.top();
        if (parentRenderer instanceof TextSvgBranchRenderer && !"".equals(wholeText = textNode.wholeText()) && !SvgTextUtil.isOnlyWhiteSpace(wholeText)) {
            TextLeafSvgNodeRenderer textLeaf = new TextLeafSvgNodeRenderer();
            textLeaf.setParent(parentRenderer);
            textLeaf.setAttribute("text_content", wholeText);
            ((TextSvgBranchRenderer)parentRenderer).addChild(textLeaf);
        }
    }

    IElementNode findFirstElement(INode node, String tagName) {
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(node);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode == null) {
                return null;
            }
            if (currentNode instanceof IElementNode && ((IElementNode)currentNode).name() != null && ((IElementNode)currentNode).name().equals(tagName)) {
                return (IElementNode)currentNode;
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }
}

