/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfSquareAnnotation
extends PdfMarkupAnnotation {
    public PdfSquareAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfSquareAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Square;
    }

    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    public PdfSquareAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfSquareAnnotation)this.put(PdfName.BS, borderStyle);
    }

    public PdfSquareAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    public PdfSquareAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    public PdfArray getRectangleDifferences() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.RD);
    }

    public PdfSquareAnnotation setRectangleDifferences(PdfArray rect) {
        return (PdfSquareAnnotation)this.put(PdfName.RD, rect);
    }

    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    public PdfSquareAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfSquareAnnotation)this.put(PdfName.BE, borderEffect);
    }

    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    public PdfSquareAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfSquareAnnotation)this.put(PdfName.IC, interiorColor);
    }

    public PdfSquareAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }
}

