/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityPropertiesToStructElem;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BackedAccessibilityProperties
extends AccessibilityProperties {
    private TagTreePointer pointerToBackingElem;

    BackedAccessibilityProperties(TagTreePointer pointerToBackingElem) {
        this.pointerToBackingElem = new TagTreePointer(pointerToBackingElem);
    }

    @Override
    public String getRole() {
        return this.getBackingElem().getRole().getValue();
    }

    @Override
    public AccessibilityProperties setRole(String role) {
        this.getBackingElem().setRole(PdfStructTreeRoot.convertRoleToPdfName(role));
        return this;
    }

    @Override
    public String getLanguage() {
        return this.toUnicodeString(this.getBackingElem().getLang());
    }

    @Override
    public AccessibilityProperties setLanguage(String language) {
        this.getBackingElem().setLang(new PdfString(language, "UnicodeBig"));
        return this;
    }

    @Override
    public String getActualText() {
        return this.toUnicodeString(this.getBackingElem().getActualText());
    }

    @Override
    public AccessibilityProperties setActualText(String actualText) {
        this.getBackingElem().setActualText(new PdfString(actualText, "UnicodeBig"));
        return this;
    }

    @Override
    public String getAlternateDescription() {
        return this.toUnicodeString(this.getBackingElem().getAlt());
    }

    @Override
    public AccessibilityProperties setAlternateDescription(String alternateDescription) {
        this.getBackingElem().setAlt(new PdfString(alternateDescription, "UnicodeBig"));
        return this;
    }

    @Override
    public String getExpansion() {
        return this.toUnicodeString(this.getBackingElem().getE());
    }

    @Override
    public AccessibilityProperties setExpansion(String expansion) {
        this.getBackingElem().setE(new PdfString(expansion, "UnicodeBig"));
        return this;
    }

    @Override
    public AccessibilityProperties addAttributes(PdfStructureAttributes attributes) {
        return this.addAttributes(-1, attributes);
    }

    @Override
    public AccessibilityProperties addAttributes(int index, PdfStructureAttributes attributes) {
        if (attributes == null) {
            return this;
        }
        PdfObject attributesObject = this.getBackingElem().getAttributes(false);
        PdfObject combinedAttributes = AccessibilityPropertiesToStructElem.combineAttributesList(attributesObject, index, Collections.singletonList(attributes), ((PdfDictionary)this.getBackingElem().getPdfObject()).getAsNumber(PdfName.R));
        this.getBackingElem().setAttributes(combinedAttributes);
        return this;
    }

    @Override
    public AccessibilityProperties clearAttributes() {
        ((PdfDictionary)this.getBackingElem().getPdfObject()).remove(PdfName.A);
        return this;
    }

    @Override
    public List<PdfStructureAttributes> getAttributesList() {
        ArrayList<PdfStructureAttributes> attributesList = new ArrayList<PdfStructureAttributes>();
        PdfObject elemAttributesObj = this.getBackingElem().getAttributes(false);
        if (elemAttributesObj != null) {
            if (elemAttributesObj.isDictionary()) {
                attributesList.add(new PdfStructureAttributes((PdfDictionary)elemAttributesObj));
            } else if (elemAttributesObj.isArray()) {
                PdfArray attributesArray = (PdfArray)elemAttributesObj;
                for (PdfObject attributeObj : attributesArray) {
                    if (!attributeObj.isDictionary()) continue;
                    attributesList.add(new PdfStructureAttributes((PdfDictionary)attributeObj));
                }
            }
        }
        return attributesList;
    }

    @Override
    public AccessibilityProperties setPhoneme(String phoneme) {
        this.getBackingElem().setPhoneme(new PdfString(phoneme));
        return this;
    }

    @Override
    public String getPhoneme() {
        return this.toUnicodeString(this.getBackingElem().getPhoneme());
    }

    @Override
    public AccessibilityProperties setPhoneticAlphabet(String phoneticAlphabet) {
        this.getBackingElem().setPhoneticAlphabet(PdfStructTreeRoot.convertRoleToPdfName(phoneticAlphabet));
        return this;
    }

    @Override
    public String getPhoneticAlphabet() {
        return this.getBackingElem().getPhoneticAlphabet().getValue();
    }

    @Override
    public AccessibilityProperties setNamespace(PdfNamespace namespace) {
        this.getBackingElem().setNamespace(namespace);
        this.pointerToBackingElem.getContext().ensureNamespaceRegistered(namespace);
        return this;
    }

    @Override
    public PdfNamespace getNamespace() {
        return this.getBackingElem().getNamespace();
    }

    @Override
    public AccessibilityProperties addRef(TagTreePointer treePointer) {
        this.getBackingElem().addRef(treePointer.getCurrentStructElem());
        return this;
    }

    @Override
    public List<TagTreePointer> getRefsList() {
        ArrayList<TagTreePointer> refsList = new ArrayList<TagTreePointer>();
        for (PdfStructElem ref : this.getBackingElem().getRefsList()) {
            refsList.add(new TagTreePointer(ref, this.pointerToBackingElem.getDocument()));
        }
        return Collections.unmodifiableList(refsList);
    }

    @Override
    public AccessibilityProperties clearRefs() {
        ((PdfDictionary)this.getBackingElem().getPdfObject()).remove(PdfName.Ref);
        return this;
    }

    private PdfStructElem getBackingElem() {
        return this.pointerToBackingElem.getCurrentStructElem();
    }

    private String toUnicodeString(PdfString pdfString) {
        return pdfString != null ? pdfString.toUnicodeString() : null;
    }
}

