/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.Iterator;

class DocTrueTypeFont
extends TrueTypeFont
implements IDocFontProgram {
    private static final long serialVersionUID = 4611535787920619829L;
    private PdfStream fontFile;
    private PdfName fontFileName;
    private PdfName subtype;
    private int missingWidth = 0;

    private DocTrueTypeFont(PdfDictionary fontDictionary) {
        PdfName baseFontName = fontDictionary.getAsName(PdfName.BaseFont);
        if (baseFontName != null) {
            this.setFontName(baseFontName.getValue());
        } else {
            this.setFontName(FontUtil.createRandomFontName());
        }
        this.subtype = fontDictionary.getAsName(PdfName.Subtype);
    }

    static TrueTypeFont createFontProgram(PdfDictionary fontDictionary, FontEncoding fontEncoding, CMapToUnicode toUnicode) {
        DocTrueTypeFont fontProgram = new DocTrueTypeFont(fontDictionary);
        DocTrueTypeFont.fillFontDescriptor(fontProgram, fontDictionary.getAsDictionary(PdfName.FontDescriptor));
        PdfNumber firstCharNumber = fontDictionary.getAsNumber(PdfName.FirstChar);
        int firstChar = firstCharNumber != null ? Math.max(firstCharNumber.intValue(), 0) : 0;
        int[] widths = FontUtil.convertSimpleWidthsArray(fontDictionary.getAsArray(PdfName.Widths), firstChar, fontProgram.getMissingWidth());
        fontProgram.avgWidth = 0;
        int glyphsWithWidths = 0;
        for (int i = 0; i < 256; ++i) {
            Glyph glyph = new Glyph(i, widths[i], fontEncoding.getUnicode(i));
            fontProgram.codeToGlyph.put(i, glyph);
            if (glyph.hasValidUnicode() && fontEncoding.convertToByte(glyph.getUnicode()) == i) {
                fontProgram.unicodeToGlyph.put(glyph.getUnicode(), glyph);
            } else if (toUnicode != null) {
                glyph.setChars(toUnicode.lookup(i));
            }
            if (widths[i] <= 0) continue;
            ++glyphsWithWidths;
            fontProgram.avgWidth += widths[i];
        }
        if (glyphsWithWidths != 0) {
            fontProgram.avgWidth /= glyphsWithWidths;
        }
        return fontProgram;
    }

    static TrueTypeFont createFontProgram(PdfDictionary fontDictionary, CMapToUnicode toUnicode) {
        DocTrueTypeFont fontProgram = new DocTrueTypeFont(fontDictionary);
        PdfDictionary fontDescriptor = fontDictionary.getAsDictionary(PdfName.FontDescriptor);
        DocTrueTypeFont.fillFontDescriptor(fontProgram, fontDescriptor);
        int dw = fontDescriptor != null && fontDescriptor.containsKey(PdfName.DW) ? fontDescriptor.getAsInt(PdfName.DW) : (fontDictionary.containsKey(PdfName.DW) ? fontDictionary.getAsInt(PdfName.DW) : 1000);
        IntHashtable widths = null;
        if (toUnicode != null) {
            widths = FontUtil.convertCompositeWidthsArray(fontDictionary.getAsArray(PdfName.W));
            fontProgram.avgWidth = 0;
            Iterator iterator = toUnicode.getCodes().iterator();
            while (iterator.hasNext()) {
                int cid;
                int width = widths.containsKey(cid = ((Integer)iterator.next()).intValue()) ? widths.get(cid) : dw;
                Glyph glyph = new Glyph(cid, width, toUnicode.lookup(cid));
                if (glyph.hasValidUnicode()) {
                    fontProgram.unicodeToGlyph.put(glyph.getUnicode(), glyph);
                }
                fontProgram.codeToGlyph.put(cid, glyph);
                fontProgram.avgWidth += width;
            }
            if (fontProgram.codeToGlyph.size() != 0) {
                fontProgram.avgWidth /= fontProgram.codeToGlyph.size();
            }
        }
        if (fontProgram.codeToGlyph.get(0) == null) {
            fontProgram.codeToGlyph.put(0, new Glyph(0, widths != null && widths.containsKey(0) ? widths.get(0) : dw, -1));
        }
        return fontProgram;
    }

    @Override
    public PdfStream getFontFile() {
        return this.fontFile;
    }

    @Override
    public PdfName getFontFileName() {
        return this.fontFileName;
    }

    @Override
    public PdfName getSubtype() {
        return this.subtype;
    }

    public boolean isBuiltWith(String fontName) {
        return false;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    static void fillFontDescriptor(DocTrueTypeFont font, PdfDictionary fontDesc) {
        PdfName[] fontFileNames;
        PdfNumber flagsValue;
        PdfString fontFamily;
        PdfArray bboxValue;
        PdfName fontStretch;
        if (fontDesc == null) {
            return;
        }
        PdfNumber v = fontDesc.getAsNumber(PdfName.Ascent);
        if (v != null) {
            font.setTypoAscender(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.Descent)) != null) {
            font.setTypoDescender(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.CapHeight)) != null) {
            font.setCapHeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.XHeight)) != null) {
            font.setXHeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.ItalicAngle)) != null) {
            font.setItalicAngle(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.StemV)) != null) {
            font.setStemV(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.StemH)) != null) {
            font.setStemH(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.FontWeight)) != null) {
            font.setFontWeight(v.intValue());
        }
        if ((v = fontDesc.getAsNumber(PdfName.MissingWidth)) != null) {
            font.missingWidth = v.intValue();
        }
        if ((fontStretch = fontDesc.getAsName(PdfName.FontStretch)) != null) {
            font.setFontStretch(fontStretch.getValue());
        }
        if ((bboxValue = fontDesc.getAsArray(PdfName.FontBBox)) != null) {
            int t;
            int[] bbox = new int[]{bboxValue.getAsNumber(0).intValue(), bboxValue.getAsNumber(1).intValue(), bboxValue.getAsNumber(2).intValue(), bboxValue.getAsNumber(3).intValue()};
            if (bbox[0] > bbox[2]) {
                t = bbox[0];
                bbox[0] = bbox[2];
                bbox[2] = t;
            }
            if (bbox[1] > bbox[3]) {
                t = bbox[1];
                bbox[1] = bbox[3];
                bbox[3] = t;
            }
            font.setBbox(bbox);
            if (font.getFontMetrics().getTypoAscender() == 0 && font.getFontMetrics().getTypoDescender() == 0) {
                float maxAscent = Math.max(bbox[3], font.getFontMetrics().getTypoAscender());
                float minDescent = Math.min(bbox[1], font.getFontMetrics().getTypoDescender());
                font.setTypoAscender((int)(maxAscent * 1000.0f / (maxAscent - minDescent)));
                font.setTypoDescender((int)(minDescent * 1000.0f / (maxAscent - minDescent)));
            }
        }
        if ((fontFamily = fontDesc.getAsString(PdfName.FontFamily)) != null) {
            font.setFontFamily(fontFamily.getValue());
        }
        if ((flagsValue = fontDesc.getAsNumber(PdfName.Flags)) != null) {
            int flags = flagsValue.intValue();
            if ((flags & 1) != 0) {
                font.setFixedPitch(true);
            }
            if ((flags & 0x40000) != 0) {
                font.setBold(true);
            }
        }
        for (PdfName fontFile : fontFileNames = new PdfName[]{PdfName.FontFile, PdfName.FontFile2, PdfName.FontFile3}) {
            if (!fontDesc.containsKey(fontFile)) continue;
            font.fontFileName = fontFile;
            font.fontFile = fontDesc.getAsStream(fontFile);
            break;
        }
    }
}

