/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.ContextualRule;
import com.itextpdf.io.font.otf.ContextualTable;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.util.List;

public abstract class ChainingContextualTable<T extends ContextualRule>
extends ContextualTable<T> {
    protected ChainingContextualTable(OpenTypeFontTableReader openReader, int lookupFlag) {
        super(openReader, lookupFlag);
    }

    @Override
    public T getMatchingContextRule(GlyphLine line) {
        if (line.idx >= line.end) {
            return null;
        }
        Glyph g = line.get(line.idx);
        List rules = this.getSetOfRulesForStartGlyph(g.getCode());
        for (ContextualRule rule : rules) {
            int lastGlyphIndex = this.checkIfContextMatch(line, rule);
            if (lastGlyphIndex == -1 || !this.checkIfLookaheadContextMatch(line, rule, lastGlyphIndex) || !this.checkIfBacktrackContextMatch(line, rule)) continue;
            line.start = line.idx;
            line.end = lastGlyphIndex + 1;
            return (T)rule;
        }
        return null;
    }

    protected boolean checkIfLookaheadContextMatch(GlyphLine line, T rule, int startIdx) {
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = startIdx;
        for (int j = 0; j < ((ContextualRule)rule).getLookaheadContextLength(); ++j) {
            gidx.nextGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph != null && ((ContextualRule)rule).isGlyphMatchesLookahead(gidx.glyph.getCode(), j)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkIfBacktrackContextMatch(GlyphLine line, T rule) {
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = line.idx;
        for (int j = 0; j < ((ContextualRule)rule).getBacktrackContextLength(); ++j) {
            gidx.previousGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph != null && ((ContextualRule)rule).isGlyphMatchesBacktrack(gidx.glyph.getCode(), j)) continue;
            return false;
        }
        return true;
    }
}

