/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.util;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.element.SvgImage;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.xobject.SvgImageXObject;

public class SvgProcessingUtil {
    private ResourceResolver resourceResolver;

    public SvgProcessingUtil(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Image createImageFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        SvgImageXObject xObject = (SvgImageXObject)this.createXObjectFromProcessingResult(result, pdfDocument);
        return new SvgImage(xObject);
    }

    public Image createSvgImageFromProcessingResult(ISvgProcessorResult result) {
        return this.createImageFromProcessingResult(result, null);
    }

    public PdfFormXObject createXObjectFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        ISvgNodeRenderer topSvgRenderer = result.getRootRenderer();
        float[] wh = SvgConverter.extractWidthAndHeight((ISvgNodeRenderer)topSvgRenderer);
        float width = wh[0];
        float height = wh[1];
        SvgImageXObject svgImageXObject = new SvgImageXObject(new Rectangle(0.0f, 0.0f, width, height), result, this.resourceResolver);
        if (pdfDocument != null) {
            svgImageXObject.generate(pdfDocument);
        }
        return svgImageXObject;
    }
}

